/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.classes;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemData;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.classes.ClassesLabels;
import com.ibm.java.diagnostics.healthcenter.classes.Messages;
import com.ibm.java.diagnostics.healthcenter.classes.datamodel.ClassLoadingDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.classes.datamodel.ClassLoadingEvent;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerImpl;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePointHandler;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracedThread;
import com.ibm.java.diagnostics.healthcenter.marshalling.data.events.ClassesInternalObject;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassesTracePointHandler
implements TracePointHandler {
    private static final Logger TRACE = LogFactory.getTrace(ClassesTracePointHandler.class);
    private static final String CLASSNAME = ClassesTracePointHandler.class.getName();
    private OutputProperties props;
    private AxisPair axisPair = null;
    private XDataAxis xAxis = null;
    private static final DataFactory factory = DataFactory.getFactory();
    private static String lastClassName = null;

    @Override
    public void handleTraceStart(DynamicSource dynamicSource, TraceMetaData traceMetaData, DataBuilder dataBuilder, OutputProperties outputProperties) {
        Object object;
        String string;
        TRACE.entering(CLASSNAME, "handleTraceStart");
        this.props = outputProperties;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(ClassesLabels.DATA_LABEL);
        if (dataBuilder2 instanceof SubsystemData && (string = (object = (SubsystemData)((Object)dataBuilder2)).getPerspectiveID()) == null) {
            dataBuilder.removeData(ClassesLabels.DATA_LABEL);
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine("Internal error: Postprocessed data was not cleared properly - deleting existing data.");
            }
        }
        if (this.xAxis != null) {
            TRACE.logp(Level.WARNING, CLASSNAME, "handleTraceStart", "xAxis already exists");
        }
        this.xAxis = AxisUtil.prepareXAxis(this.props);
        object = AxisUtil.prepareBinaryAxis(this.props);
        if (this.axisPair != null) {
            TRACE.logp(Level.WARNING, CLASSNAME, "handleTraceStart", Messages.getString("ClassesTracePointHandler.axispair.exists"));
        }
        this.axisPair = factory.createAxisPair(this.xAxis, (YDataAxis)object);
        TRACE.exiting(CLASSNAME, "handleTraceStart");
    }

    protected SubsystemDataBuilder getClassesData(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(ClassesLabels.DATA_LABEL);
        if (dataBuilder2 instanceof SubsystemDataBuilder) {
            subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createClassesData();
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private SubsystemDataBuilder createClassesData() {
        TRACE.entering(CLASSNAME, "createClassesData");
        SubsystemDataBuilder subsystemDataBuilder = factory.createSubsystemData(ClassesLabels.DATA_LABEL, "com.ibm.java.diagnostics.healthcenter.classes.perspective");
        TRACE.exiting(CLASSNAME, "createClassesData");
        return subsystemDataBuilder;
    }

    @Override
    public void handleTracePoint(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracePoint tracePoint, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "handleTracePoint");
        String string = tracePoint.getComponent();
        if ("j9bcu".equals(string) && tracePoint.getID() == 1 || "j9shr".equals(string) && tracePoint.getID() == 51 || "j9shr".equals(string) && tracePoint.getID() == 1326) {
            SubsystemDataBuilder subsystemDataBuilder = this.getClassesData(dataBuilder);
            DataBuilder dataBuilder2 = subsystemDataBuilder.getData(ClassesLabels.LOADED_CLASSES);
            if (dataBuilder2 == null) {
                dataBuilder2 = new TwoDimensionalDataImpl(ClassesLabels.LOADED_CLASSES, this.axisPair);
                if (!MarshallerImpl.getMarshaller().isEventOnlyMode()) {
                    subsystemDataBuilder.addData(dataBuilder2);
                }
            }
            this.addTracePoint(tracePoint, dataBuilder2, traceMetaData);
        }
        TRACE.exiting(CLASSNAME, "handleTracePoint");
    }

    @Override
    public void handleMissingData(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracedThread tracedThread, double d, int n, DataBuilder dataBuilder, OutputProperties outputProperties) {
    }

    private void addTracePoint(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        String string;
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        boolean bl = false;
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        if (tracePoint.getID() == 51 || tracePoint.getID() == 1326) {
            bl = true;
            string = (String)objectArray[0];
        } else {
            string = (String)objectArray[1];
        }
        if (string.equals(lastClassName)) {
            lastClassName = string;
            return;
        }
        lastClassName = string;
        ClassesInternalObject classesInternalObject = new ClassesInternalObject((long)d, string, bl);
        MarshallerImpl.getMarshaller().getClassesEventHandler().addEvent(classesInternalObject);
        if (MarshallerImpl.getMarshaller().isEventOnlyMode()) {
            return;
        }
        ((TwoDimensionalDataBuilder)dataBuilder).addDataPointBuilder(new ClassLoadingDataPointImpl(0, d, this.axisPair, new ClassLoadingEvent(string, bl)));
    }
}

