/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public class MemoryDataProvider {
    private static final String COMMA = ",";
    private static final String EQUALS = "=";

    public static String getJMXData() {
        return MemoryDataProvider.getMemoryInformation();
    }

    private static String getMemoryInformation() {
        String string = "MemorySource," + System.currentTimeMillis() + COMMA + "totalphysicalmemory" + EQUALS + MemoryDataProvider.getPhysicalMemorySizeImpl() + COMMA;
        return string;
    }

    public boolean isDataSupported() {
        boolean bl = true;
        String string = System.getProperty("os.name");
        if ("i5/OS".equals(string) || "OS/400".equals(string)) {
            bl = false;
        }
        return bl;
    }

    private static long getPhysicalMemorySizeImpl() {
        Class[] classArray = new Class[]{};
        long l = -1L;
        if (!System.getProperty("java.vm.vendor").contains("IBM")) {
            try {
                Class<?> clazz = Class.forName("com.sun.management.OperatingSystemMXBean");
                OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
                Method method = clazz.getDeclaredMethod("getTotalPhysicalMemorySize", classArray);
                Long l2 = (Long)method.invoke((Object)operatingSystemMXBean, (Object[])null);
                if (l2 != null) {
                    l = l2;
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if (System.getProperty("java.vm.vendor").contains("IBM")) {
            try {
                Class<?> clazz = Class.forName("com.ibm.lang.management.OperatingSystemMXBean");
                OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
                Method method = clazz.getDeclaredMethod("getTotalPhysicalMemory", classArray);
                Long l3 = (Long)method.invoke((Object)operatingSystemMXBean, (Object[])null);
                if (l3 != null) {
                    l = l3;
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        return l;
    }
}

