/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.data;

import com.ibm.java.diagnostics.common.datamodel.impl.data.Type;
import com.ibm.java.diagnostics.common.util.cache.LeastRecentlyUsedCache;

public class ArrayType
extends Type {
    private static final LeastRecentlyUsedCache<String, ArrayType> CACHE = new LeastRecentlyUsedCache();
    private static final String BRACKETS = "[]";
    private final Type type;
    private final int depth;

    public ArrayType(String string) {
        super(ArrayType.constructNiceName(ArrayType.getTypeOfArray(string).getName(), ArrayType.getDepth(string)));
        this.type = ArrayType.getTypeOfArray(string);
        this.depth = ArrayType.getDepth(string);
    }

    private static Type getTypeOfArray(String string) {
        int n = string.lastIndexOf(91) + 1;
        if (n >= 1) {
            String string2 = string.substring(n);
            return Type.getType(string2);
        }
        return Type.getType(string);
    }

    private static int getDepth(String string) {
        int n = string.lastIndexOf(91) + 1;
        return n;
    }

    private static String constructNiceName(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(BRACKETS);
        }
        return stringBuilder.toString();
    }

    public static ArrayType getType(String string) {
        ArrayType arrayType = CACHE.get(string);
        if (arrayType == null) {
            arrayType = new ArrayType(string);
            CACHE.put(string, arrayType);
        }
        return arrayType;
    }

    @Override
    public String getUnqualifiedName() {
        return ArrayType.constructNiceName(this.type.getUnqualifiedName(), this.depth);
    }

    @Override
    public String getAbbreviatedName() {
        return ArrayType.constructNiceName(this.type.getAbbreviatedName(), this.depth);
    }
}

