/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.converters;

import com.ibm.java.diagnostics.common.datamodel.data.axes.LinearUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AbstractUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.util.Messages;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUnitConverter
extends AbstractUnitConverter
implements LinearUnitConverter {
    public static final String formatString = Messages.getString("DateUnitConverter.date.format");
    private final DateFormat format = new SimpleDateFormat(formatString);
    private static final UnitConverterDefinition definition = new UnitConverterDefinitionImpl(UnitLabels.MILLISECONDS_SINCE_EPOCH, UnitLabels.TIMESTAMP, UnitLabels.DATE);
    private OutputProperties out;

    public DateUnitConverter(OutputProperties outputProperties) {
        this.out = outputProperties;
    }

    @Override
    public double convert(double d, int n) {
        return this.convert(d);
    }

    @Override
    public double convert(double d) {
        return d;
    }

    @Override
    public double reverseConvert(double d) {
        return d;
    }

    @Override
    public String unconvertedFormat(double d) {
        TimeZone timeZone;
        long l = Math.round(d);
        if (this.out != null && (timeZone = this.out.getTimeZone()) != null) {
            this.format.setTimeZone(timeZone);
        }
        return this.format.format(new Date(l));
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return this.unconvertedFormat(d);
    }

    @Override
    public double parseUnconverted(String string) {
        try {
            double d = this.format.parse(string).getTime();
            return d;
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return definition;
    }

    @Override
    public void setOffset(double d) {
    }

    @Override
    public boolean shouldFormatWithUnits() {
        return false;
    }
}

