/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.axes;

import com.ibm.java.diagnostics.common.datamodel.data.axes.Axis;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.DataAxisImpl;
import com.ibm.java.diagnostics.common.util.weak.WeakHashSet;
import java.rmi.server.UID;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;

public abstract class AxisImpl
implements Axis {
    private final String defaultUnits;
    private final String axisIdentifier = new UID().toString();
    private final String baseLabel;
    private Set<DataAxisImpl> unitAxisListeners;
    private String units;
    private final int type;
    private Preferences preferences;
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String OPEN_PARENTHESIS = " (";
    private String unitsKey;

    public AxisImpl(String string, String string2) {
        this(string, string2, 0);
    }

    public AxisImpl(String string, String string2, int n) {
        this.defaultUnits = string2;
        this.baseLabel = string;
        this.unitAxisListeners = new WeakHashSet<DataAxisImpl>();
        this.type = n;
        this.units = string2;
    }

    public void addAxisUnitListener(DataAxisImpl dataAxisImpl) {
        this.unitAxisListeners.add(dataAxisImpl);
    }

    @Override
    public String getUnits() {
        if (this.units != null) {
            return this.units;
        }
        return this.defaultUnits;
    }

    @Override
    public Set<String> getPossibleUnits() {
        DataAxisImpl[] dataAxisImplArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (DataAxisImpl dataAxisImpl : dataAxisImplArray = this.unitAxisListeners.toArray(new DataAxisImpl[0])) {
            String[] stringArray = dataAxisImpl.getPossibleUnits();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        return hashSet;
    }

    @Override
    public void setUnits(String string) {
        this.units = string;
        String string2 = this.getUnits();
        for (DataAxisImpl dataAxisImpl : this.unitAxisListeners) {
            dataAxisImpl.setUnits(string2);
        }
        if (this.preferences != null && string != null) {
            this.preferences.put(this.unitsKey, string2);
        }
        for (DataAxisImpl dataAxisImpl : this.unitAxisListeners) {
            dataAxisImpl.correctObsoleteBounds();
        }
    }

    @Override
    public String getAxisIdentifierName() {
        return this.axisIdentifier;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getLabel() {
        return this.baseLabel;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (!(object instanceof AxisImpl)) {
            bl = false;
        } else {
            AxisImpl axisImpl = (AxisImpl)object;
            bl = this.baseLabel == null || this.baseLabel.equals(axisImpl.baseLabel);
        }
        return bl;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.type != 1) {
            return this.baseLabel + OPEN_PARENTHESIS + this.axisIdentifier + CLOSE_PARENTHESIS;
        }
        return this.baseLabel;
    }
}

