/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package testing

import (
	mock "github.com/stretchr/testify/mock"
	v10 "k8s.io/api/core/v1"
	"k8s.io/kubelet/pkg/apis/podresources/v1"
)

// NewMockDevicesProvider creates a new instance of MockDevicesProvider. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockDevicesProvider(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockDevicesProvider {
	mock := &MockDevicesProvider{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockDevicesProvider is an autogenerated mock type for the DevicesProvider type
type MockDevicesProvider struct {
	mock.Mock
}

type MockDevicesProvider_Expecter struct {
	mock *mock.Mock
}

func (_m *MockDevicesProvider) EXPECT() *MockDevicesProvider_Expecter {
	return &MockDevicesProvider_Expecter{mock: &_m.Mock}
}

// GetAllocatableDevices provides a mock function for the type MockDevicesProvider
func (_mock *MockDevicesProvider) GetAllocatableDevices() []*v1.ContainerDevices {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetAllocatableDevices")
	}

	var r0 []*v1.ContainerDevices
	if returnFunc, ok := ret.Get(0).(func() []*v1.ContainerDevices); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.ContainerDevices)
		}
	}
	return r0
}

// MockDevicesProvider_GetAllocatableDevices_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetAllocatableDevices'
type MockDevicesProvider_GetAllocatableDevices_Call struct {
	*mock.Call
}

// GetAllocatableDevices is a helper method to define mock.On call
func (_e *MockDevicesProvider_Expecter) GetAllocatableDevices() *MockDevicesProvider_GetAllocatableDevices_Call {
	return &MockDevicesProvider_GetAllocatableDevices_Call{Call: _e.mock.On("GetAllocatableDevices")}
}

func (_c *MockDevicesProvider_GetAllocatableDevices_Call) Run(run func()) *MockDevicesProvider_GetAllocatableDevices_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockDevicesProvider_GetAllocatableDevices_Call) Return(containerDevicess []*v1.ContainerDevices) *MockDevicesProvider_GetAllocatableDevices_Call {
	_c.Call.Return(containerDevicess)
	return _c
}

func (_c *MockDevicesProvider_GetAllocatableDevices_Call) RunAndReturn(run func() []*v1.ContainerDevices) *MockDevicesProvider_GetAllocatableDevices_Call {
	_c.Call.Return(run)
	return _c
}

// GetDevices provides a mock function for the type MockDevicesProvider
func (_mock *MockDevicesProvider) GetDevices(podUID string, containerName string) []*v1.ContainerDevices {
	ret := _mock.Called(podUID, containerName)

	if len(ret) == 0 {
		panic("no return value specified for GetDevices")
	}

	var r0 []*v1.ContainerDevices
	if returnFunc, ok := ret.Get(0).(func(string, string) []*v1.ContainerDevices); ok {
		r0 = returnFunc(podUID, containerName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.ContainerDevices)
		}
	}
	return r0
}

// MockDevicesProvider_GetDevices_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDevices'
type MockDevicesProvider_GetDevices_Call struct {
	*mock.Call
}

// GetDevices is a helper method to define mock.On call
//   - podUID string
//   - containerName string
func (_e *MockDevicesProvider_Expecter) GetDevices(podUID interface{}, containerName interface{}) *MockDevicesProvider_GetDevices_Call {
	return &MockDevicesProvider_GetDevices_Call{Call: _e.mock.On("GetDevices", podUID, containerName)}
}

func (_c *MockDevicesProvider_GetDevices_Call) Run(run func(podUID string, containerName string)) *MockDevicesProvider_GetDevices_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockDevicesProvider_GetDevices_Call) Return(containerDevicess []*v1.ContainerDevices) *MockDevicesProvider_GetDevices_Call {
	_c.Call.Return(containerDevicess)
	return _c
}

func (_c *MockDevicesProvider_GetDevices_Call) RunAndReturn(run func(podUID string, containerName string) []*v1.ContainerDevices) *MockDevicesProvider_GetDevices_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateAllocatedDevices provides a mock function for the type MockDevicesProvider
func (_mock *MockDevicesProvider) UpdateAllocatedDevices() {
	_mock.Called()
	return
}

// MockDevicesProvider_UpdateAllocatedDevices_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateAllocatedDevices'
type MockDevicesProvider_UpdateAllocatedDevices_Call struct {
	*mock.Call
}

// UpdateAllocatedDevices is a helper method to define mock.On call
func (_e *MockDevicesProvider_Expecter) UpdateAllocatedDevices() *MockDevicesProvider_UpdateAllocatedDevices_Call {
	return &MockDevicesProvider_UpdateAllocatedDevices_Call{Call: _e.mock.On("UpdateAllocatedDevices")}
}

func (_c *MockDevicesProvider_UpdateAllocatedDevices_Call) Run(run func()) *MockDevicesProvider_UpdateAllocatedDevices_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockDevicesProvider_UpdateAllocatedDevices_Call) Return() *MockDevicesProvider_UpdateAllocatedDevices_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockDevicesProvider_UpdateAllocatedDevices_Call) RunAndReturn(run func()) *MockDevicesProvider_UpdateAllocatedDevices_Call {
	_c.Run(run)
	return _c
}

// NewMockPodsProvider creates a new instance of MockPodsProvider. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockPodsProvider(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockPodsProvider {
	mock := &MockPodsProvider{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockPodsProvider is an autogenerated mock type for the PodsProvider type
type MockPodsProvider struct {
	mock.Mock
}

type MockPodsProvider_Expecter struct {
	mock *mock.Mock
}

func (_m *MockPodsProvider) EXPECT() *MockPodsProvider_Expecter {
	return &MockPodsProvider_Expecter{mock: &_m.Mock}
}

// GetActivePods provides a mock function for the type MockPodsProvider
func (_mock *MockPodsProvider) GetActivePods() []*v10.Pod {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetActivePods")
	}

	var r0 []*v10.Pod
	if returnFunc, ok := ret.Get(0).(func() []*v10.Pod); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v10.Pod)
		}
	}
	return r0
}

// MockPodsProvider_GetActivePods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetActivePods'
type MockPodsProvider_GetActivePods_Call struct {
	*mock.Call
}

// GetActivePods is a helper method to define mock.On call
func (_e *MockPodsProvider_Expecter) GetActivePods() *MockPodsProvider_GetActivePods_Call {
	return &MockPodsProvider_GetActivePods_Call{Call: _e.mock.On("GetActivePods")}
}

func (_c *MockPodsProvider_GetActivePods_Call) Run(run func()) *MockPodsProvider_GetActivePods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPodsProvider_GetActivePods_Call) Return(pods []*v10.Pod) *MockPodsProvider_GetActivePods_Call {
	_c.Call.Return(pods)
	return _c
}

func (_c *MockPodsProvider_GetActivePods_Call) RunAndReturn(run func() []*v10.Pod) *MockPodsProvider_GetActivePods_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodByName provides a mock function for the type MockPodsProvider
func (_mock *MockPodsProvider) GetPodByName(namespace string, name string) (*v10.Pod, bool) {
	ret := _mock.Called(namespace, name)

	if len(ret) == 0 {
		panic("no return value specified for GetPodByName")
	}

	var r0 *v10.Pod
	var r1 bool
	if returnFunc, ok := ret.Get(0).(func(string, string) (*v10.Pod, bool)); ok {
		return returnFunc(namespace, name)
	}
	if returnFunc, ok := ret.Get(0).(func(string, string) *v10.Pod); ok {
		r0 = returnFunc(namespace, name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v10.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(string, string) bool); ok {
		r1 = returnFunc(namespace, name)
	} else {
		r1 = ret.Get(1).(bool)
	}
	return r0, r1
}

// MockPodsProvider_GetPodByName_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodByName'
type MockPodsProvider_GetPodByName_Call struct {
	*mock.Call
}

// GetPodByName is a helper method to define mock.On call
//   - namespace string
//   - name string
func (_e *MockPodsProvider_Expecter) GetPodByName(namespace interface{}, name interface{}) *MockPodsProvider_GetPodByName_Call {
	return &MockPodsProvider_GetPodByName_Call{Call: _e.mock.On("GetPodByName", namespace, name)}
}

func (_c *MockPodsProvider_GetPodByName_Call) Run(run func(namespace string, name string)) *MockPodsProvider_GetPodByName_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockPodsProvider_GetPodByName_Call) Return(pod *v10.Pod, b bool) *MockPodsProvider_GetPodByName_Call {
	_c.Call.Return(pod, b)
	return _c
}

func (_c *MockPodsProvider_GetPodByName_Call) RunAndReturn(run func(namespace string, name string) (*v10.Pod, bool)) *MockPodsProvider_GetPodByName_Call {
	_c.Call.Return(run)
	return _c
}

// GetPods provides a mock function for the type MockPodsProvider
func (_mock *MockPodsProvider) GetPods() []*v10.Pod {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPods")
	}

	var r0 []*v10.Pod
	if returnFunc, ok := ret.Get(0).(func() []*v10.Pod); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v10.Pod)
		}
	}
	return r0
}

// MockPodsProvider_GetPods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPods'
type MockPodsProvider_GetPods_Call struct {
	*mock.Call
}

// GetPods is a helper method to define mock.On call
func (_e *MockPodsProvider_Expecter) GetPods() *MockPodsProvider_GetPods_Call {
	return &MockPodsProvider_GetPods_Call{Call: _e.mock.On("GetPods")}
}

func (_c *MockPodsProvider_GetPods_Call) Run(run func()) *MockPodsProvider_GetPods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPodsProvider_GetPods_Call) Return(pods []*v10.Pod) *MockPodsProvider_GetPods_Call {
	_c.Call.Return(pods)
	return _c
}

func (_c *MockPodsProvider_GetPods_Call) RunAndReturn(run func() []*v10.Pod) *MockPodsProvider_GetPods_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockCPUsProvider creates a new instance of MockCPUsProvider. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockCPUsProvider(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockCPUsProvider {
	mock := &MockCPUsProvider{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockCPUsProvider is an autogenerated mock type for the CPUsProvider type
type MockCPUsProvider struct {
	mock.Mock
}

type MockCPUsProvider_Expecter struct {
	mock *mock.Mock
}

func (_m *MockCPUsProvider) EXPECT() *MockCPUsProvider_Expecter {
	return &MockCPUsProvider_Expecter{mock: &_m.Mock}
}

// GetAllocatableCPUs provides a mock function for the type MockCPUsProvider
func (_mock *MockCPUsProvider) GetAllocatableCPUs() []int64 {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetAllocatableCPUs")
	}

	var r0 []int64
	if returnFunc, ok := ret.Get(0).(func() []int64); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int64)
		}
	}
	return r0
}

// MockCPUsProvider_GetAllocatableCPUs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetAllocatableCPUs'
type MockCPUsProvider_GetAllocatableCPUs_Call struct {
	*mock.Call
}

// GetAllocatableCPUs is a helper method to define mock.On call
func (_e *MockCPUsProvider_Expecter) GetAllocatableCPUs() *MockCPUsProvider_GetAllocatableCPUs_Call {
	return &MockCPUsProvider_GetAllocatableCPUs_Call{Call: _e.mock.On("GetAllocatableCPUs")}
}

func (_c *MockCPUsProvider_GetAllocatableCPUs_Call) Run(run func()) *MockCPUsProvider_GetAllocatableCPUs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockCPUsProvider_GetAllocatableCPUs_Call) Return(int64s []int64) *MockCPUsProvider_GetAllocatableCPUs_Call {
	_c.Call.Return(int64s)
	return _c
}

func (_c *MockCPUsProvider_GetAllocatableCPUs_Call) RunAndReturn(run func() []int64) *MockCPUsProvider_GetAllocatableCPUs_Call {
	_c.Call.Return(run)
	return _c
}

// GetCPUs provides a mock function for the type MockCPUsProvider
func (_mock *MockCPUsProvider) GetCPUs(podUID string, containerName string) []int64 {
	ret := _mock.Called(podUID, containerName)

	if len(ret) == 0 {
		panic("no return value specified for GetCPUs")
	}

	var r0 []int64
	if returnFunc, ok := ret.Get(0).(func(string, string) []int64); ok {
		r0 = returnFunc(podUID, containerName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]int64)
		}
	}
	return r0
}

// MockCPUsProvider_GetCPUs_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetCPUs'
type MockCPUsProvider_GetCPUs_Call struct {
	*mock.Call
}

// GetCPUs is a helper method to define mock.On call
//   - podUID string
//   - containerName string
func (_e *MockCPUsProvider_Expecter) GetCPUs(podUID interface{}, containerName interface{}) *MockCPUsProvider_GetCPUs_Call {
	return &MockCPUsProvider_GetCPUs_Call{Call: _e.mock.On("GetCPUs", podUID, containerName)}
}

func (_c *MockCPUsProvider_GetCPUs_Call) Run(run func(podUID string, containerName string)) *MockCPUsProvider_GetCPUs_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockCPUsProvider_GetCPUs_Call) Return(int64s []int64) *MockCPUsProvider_GetCPUs_Call {
	_c.Call.Return(int64s)
	return _c
}

func (_c *MockCPUsProvider_GetCPUs_Call) RunAndReturn(run func(podUID string, containerName string) []int64) *MockCPUsProvider_GetCPUs_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockMemoryProvider creates a new instance of MockMemoryProvider. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockMemoryProvider(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockMemoryProvider {
	mock := &MockMemoryProvider{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockMemoryProvider is an autogenerated mock type for the MemoryProvider type
type MockMemoryProvider struct {
	mock.Mock
}

type MockMemoryProvider_Expecter struct {
	mock *mock.Mock
}

func (_m *MockMemoryProvider) EXPECT() *MockMemoryProvider_Expecter {
	return &MockMemoryProvider_Expecter{mock: &_m.Mock}
}

// GetAllocatableMemory provides a mock function for the type MockMemoryProvider
func (_mock *MockMemoryProvider) GetAllocatableMemory() []*v1.ContainerMemory {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetAllocatableMemory")
	}

	var r0 []*v1.ContainerMemory
	if returnFunc, ok := ret.Get(0).(func() []*v1.ContainerMemory); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.ContainerMemory)
		}
	}
	return r0
}

// MockMemoryProvider_GetAllocatableMemory_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetAllocatableMemory'
type MockMemoryProvider_GetAllocatableMemory_Call struct {
	*mock.Call
}

// GetAllocatableMemory is a helper method to define mock.On call
func (_e *MockMemoryProvider_Expecter) GetAllocatableMemory() *MockMemoryProvider_GetAllocatableMemory_Call {
	return &MockMemoryProvider_GetAllocatableMemory_Call{Call: _e.mock.On("GetAllocatableMemory")}
}

func (_c *MockMemoryProvider_GetAllocatableMemory_Call) Run(run func()) *MockMemoryProvider_GetAllocatableMemory_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockMemoryProvider_GetAllocatableMemory_Call) Return(containerMemorys []*v1.ContainerMemory) *MockMemoryProvider_GetAllocatableMemory_Call {
	_c.Call.Return(containerMemorys)
	return _c
}

func (_c *MockMemoryProvider_GetAllocatableMemory_Call) RunAndReturn(run func() []*v1.ContainerMemory) *MockMemoryProvider_GetAllocatableMemory_Call {
	_c.Call.Return(run)
	return _c
}

// GetMemory provides a mock function for the type MockMemoryProvider
func (_mock *MockMemoryProvider) GetMemory(podUID string, containerName string) []*v1.ContainerMemory {
	ret := _mock.Called(podUID, containerName)

	if len(ret) == 0 {
		panic("no return value specified for GetMemory")
	}

	var r0 []*v1.ContainerMemory
	if returnFunc, ok := ret.Get(0).(func(string, string) []*v1.ContainerMemory); ok {
		r0 = returnFunc(podUID, containerName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.ContainerMemory)
		}
	}
	return r0
}

// MockMemoryProvider_GetMemory_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetMemory'
type MockMemoryProvider_GetMemory_Call struct {
	*mock.Call
}

// GetMemory is a helper method to define mock.On call
//   - podUID string
//   - containerName string
func (_e *MockMemoryProvider_Expecter) GetMemory(podUID interface{}, containerName interface{}) *MockMemoryProvider_GetMemory_Call {
	return &MockMemoryProvider_GetMemory_Call{Call: _e.mock.On("GetMemory", podUID, containerName)}
}

func (_c *MockMemoryProvider_GetMemory_Call) Run(run func(podUID string, containerName string)) *MockMemoryProvider_GetMemory_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockMemoryProvider_GetMemory_Call) Return(containerMemorys []*v1.ContainerMemory) *MockMemoryProvider_GetMemory_Call {
	_c.Call.Return(containerMemorys)
	return _c
}

func (_c *MockMemoryProvider_GetMemory_Call) RunAndReturn(run func(podUID string, containerName string) []*v1.ContainerMemory) *MockMemoryProvider_GetMemory_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockDynamicResourcesProvider creates a new instance of MockDynamicResourcesProvider. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockDynamicResourcesProvider(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockDynamicResourcesProvider {
	mock := &MockDynamicResourcesProvider{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockDynamicResourcesProvider is an autogenerated mock type for the DynamicResourcesProvider type
type MockDynamicResourcesProvider struct {
	mock.Mock
}

type MockDynamicResourcesProvider_Expecter struct {
	mock *mock.Mock
}

func (_m *MockDynamicResourcesProvider) EXPECT() *MockDynamicResourcesProvider_Expecter {
	return &MockDynamicResourcesProvider_Expecter{mock: &_m.Mock}
}

// GetDynamicResources provides a mock function for the type MockDynamicResourcesProvider
func (_mock *MockDynamicResourcesProvider) GetDynamicResources(pod *v10.Pod, container *v10.Container) []*v1.DynamicResource {
	ret := _mock.Called(pod, container)

	if len(ret) == 0 {
		panic("no return value specified for GetDynamicResources")
	}

	var r0 []*v1.DynamicResource
	if returnFunc, ok := ret.Get(0).(func(*v10.Pod, *v10.Container) []*v1.DynamicResource); ok {
		r0 = returnFunc(pod, container)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.DynamicResource)
		}
	}
	return r0
}

// MockDynamicResourcesProvider_GetDynamicResources_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDynamicResources'
type MockDynamicResourcesProvider_GetDynamicResources_Call struct {
	*mock.Call
}

// GetDynamicResources is a helper method to define mock.On call
//   - pod *v10.Pod
//   - container *v10.Container
func (_e *MockDynamicResourcesProvider_Expecter) GetDynamicResources(pod interface{}, container interface{}) *MockDynamicResourcesProvider_GetDynamicResources_Call {
	return &MockDynamicResourcesProvider_GetDynamicResources_Call{Call: _e.mock.On("GetDynamicResources", pod, container)}
}

func (_c *MockDynamicResourcesProvider_GetDynamicResources_Call) Run(run func(pod *v10.Pod, container *v10.Container)) *MockDynamicResourcesProvider_GetDynamicResources_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v10.Pod
		if args[0] != nil {
			arg0 = args[0].(*v10.Pod)
		}
		var arg1 *v10.Container
		if args[1] != nil {
			arg1 = args[1].(*v10.Container)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockDynamicResourcesProvider_GetDynamicResources_Call) Return(dynamicResources []*v1.DynamicResource) *MockDynamicResourcesProvider_GetDynamicResources_Call {
	_c.Call.Return(dynamicResources)
	return _c
}

func (_c *MockDynamicResourcesProvider_GetDynamicResources_Call) RunAndReturn(run func(pod *v10.Pod, container *v10.Container) []*v1.DynamicResource) *MockDynamicResourcesProvider_GetDynamicResources_Call {
	_c.Call.Return(run)
	return _c
}
