# Google Cloud Pubsub Exporter

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [beta]: traces, metrics, logs   |
| Distributions | [contrib] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Aexporter%2Fgooglecloudpubsub%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Aexporter%2Fgooglecloudpubsub) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Aexporter%2Fgooglecloudpubsub%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Aexporter%2Fgooglecloudpubsub) |
| Code coverage | [![codecov](https://codecov.io/github/open-telemetry/opentelemetry-collector-contrib/graph/main/badge.svg?component=exporter_googlecloudpubsub)](https://app.codecov.io/gh/open-telemetry/opentelemetry-collector-contrib/tree/main/?components%5B0%5D=exporter_googlecloudpubsub&displayType=list) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@alexvanboxel](https://www.github.com/alexvanboxel) |

[beta]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#beta
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
<!-- end autogenerated section -->

> ⚠️ This is a community-provided module. It has been developed and extensively tested at Collibra, but it is not officially supported by GCP.

This exporter sends OTLP messages to a Google Cloud [Pubsub](https://cloud.google.com/pubsub) topic.

The following configuration options are supported:

* `project` (Optional): The Google Cloud Project of the topics.
* `topic` (Required): The topic name to send OTLP data over. The topic name should be a fully qualified resource
  name (eg: `projects/otel-project/topics/otlp`).
* `compression` (Optional): Set the payload compression, only `gzip` is supported. Default is no compression.
* `watermark` Behaviour of how the `ce-time` attribute is set (see watermark section for more info)
  * `behavior` (Optional): `current` sets the `ce-time` attribute to the system clock, `earliest` sets the attribute to 
  the smallest timestamp of all the messages.
  * `allow_drift` (Optional): The maximum difference the `ce-time` attribute can be set from the system clock. When the
  drift is set to 0, the maximum drift from the clock is allowed (only applicable to `earliest`).
* `endpoint` (Optional): Override the default Pubsub Endpoint, useful when connecting to the PubSub emulator instance
  or switching between [global and regional service endpoints](https://cloud.google.com/pubsub/docs/reference/service_apis_overview#service_endpoints).
* `insecure` (Optional): allows performing “insecure” SSL connections and transfers, useful when connecting to a local
  emulator instance. Only has effect if Endpoint is not ""
* `ordering`: Configures the [PubSub ordering](https://cloud.google.com/pubsub/docs/ordering) feature, see 
  [ordering](#ordering) section for more info.
  * `enabled` (default = `false`): Enables the ordering. Default is disabled.
  * `from_resource_attribute` (no default): resource attribute that will be used as the ordering key. Required when
    `ordering.enabled` is `true`. If the resource attribute is missing or has an empty value, the messages will not be
    ordered for this resource.
  * `remove_resource_attribute` (default = `false`): if the ordering key resource attribute specified 
    `from_resource_attribute` should be removed from the resource attributes.

```yaml
exporters:
  googlecloudpubsub:
    project: my-project
    topic: projects/my-project/topics/otlp-traces
```

## Pubsub topic

The Google Cloud [Pubsub](https://cloud.google.com/pubsub) exporter doesn't automatically create topics, it expects the topic
to be created upfront. Security wise it's best to give the collector its own service account and give the
topic `Pub/Sub Publisher` permission.

## Messages

The message published on the topic are [CloudEvent](https://cloudevents.io/) compliance and uses the binary content mode
defined in the
[Google Cloud Pub/Sub Protocol Binding for CloudEvents](https://github.com/google/knative-gcp/blob/main/docs/spec/pubsub-protocol-binding.md#31-binary-content-mode)
.

The data field is either a `ExportTraceServiceRequest`, `ExportMetricsServiceRequest` or `ExportLogsServiceRequest` for 
traces, metrics or logs respectively.  Each message is accompanied by the following attributes:

| attributes       | description                                                                                                                                                       |
|------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| ce-specversion   | Follow version `1.0` of the CloudEvent spec                                                                                                                       |
| ce-source        | The source is this `/opentelemetry/collector/googlecloudpubsub/<version>` exporter                                                                                |
| ce-id            | a random `UUID` to uniquely define the message                                                                                                                    |
| ce-time          | a watermark indicating when the events, encapsulated in the OTLP message, where generated. The behavior will depend on the watermark setting in the configuration |
| ce-type          | depending on the data `org.opentelemetry.otlp.traces.v1`, `org.opentelemetry.otlp.metrics.v1` or `org.opentelemetry.otlp.logs.v1`                                 |
| content-type     | the content type is `application/protobuf`                                                                                                                        | 
| content-encoding | indicates that payload is compressed. Only gzip compression is supported                                                                                          |

### Compression
 
By default, the messages are not compressed. By compressing the messages, the cost of Pubsub can be reduced to
up to 20% of the cost. This can be done by setting the `compression` to `gzip`.

```yaml
exporters:
  googlecloudpubsub:
    project: my-project
    topic: projects/my-project/topics/otlp-traces
    compression: gzip
```

The exporter will add the `content-encoding` attribute to the message. The receiver will look at this attribute
to detect the compression that is used on the payload.

Only `gzip` is supported.

### Watermark

A watermark is a threshold that indicates where streaming processing frameworks (like Apache Beam) expects all the 
data in a window to have arrived. If new data arrives with a timestamp that's in the window but older than the 
watermark, the data is considered late data. The watermark section will change the behaviour of the `ce-time`
attribute of the message. If you don't use such frameworks you can ignore the section and the `ce-time` will 
be set to the current time, but to have a more reliable watermark behaviour in such streaming it's better to set
the `ce-time` attribute to the earliest timestamp of the messages embedded in the Pubsub message.

Setting the behaviour to `earliest` will scan all the embedded message before sending the actual Pubsub message to
figure out what the earliest timestamp is. You have to set `allow_drift`, the allowed maximum for the `ce-time` 
timestamp , if you want to behaviour to have effect as the default is `0s`.

```yaml
exporters:
  googlecloudpubsub:
    project: my-project
    topic: projects/my-project/topics/otlp-traces
    watermark: 
      behavior: earliest
      allow_drift: 1h
```

The **default** behavior is that the watermark is set to the current time of the processor. This timestamp will not differ
that much as the timestamp that is attached to a Pubsub message. Most users that don't do anything outside using Pubsub
as a global distribution system will not need anything else.

If you use Google Cloud [Dataflow](https://cloud.google.com/dataflow) and want to rely on the advanced streaming 
feature you may want to change the behavior of the watermark and de-duplication. You can leverage the unique id (`ce-id`) 
and a timestamp (`ce-time`) attributes on the message. In Apache Beam (the framework used by Dataflow) you can set the 
attributes names on the [Pubsub connector](https://beam.apache.org/releases/javadoc/2.31.0/org/apache/beam/sdk/io/gcp/pubsub/PubsubIO.Read.html#withTimestampAttribute-java.lang.String-)
via the `.withTimestampAttribute("ce-time")` and `.withIdAttribute("ce-id")` methods.  A good settings for this 
scenario is `behavior: earliest` with a reasonable `allow_drift` of `1h`.

Allowed behavior values are `current` or `earliest`. For `allow_drift` the default is `0s`, so make sure to set the 
value.

## Ordering

When ordering is enabled (`ordering.enabled`), you are required to specify a resource attribute key that will be used as
the ordering key (`ordering.from_resource_attribute`). If this resource attribute is only meant to be used as an
ordering key, you may want to choose to get this resource attribute key (`ordering.from_resource_attribute`) removed
before publishing to PubSub by enabling the `ordering.remove_resource_attribute` configuration.

```yaml
exporters:
  googlecloudpubsub:
    project: my-project
    topic: projects/my-project/topics/otlp-traces
    ordering:
      enabled: true
      from_resource_attribute: some.resource.attribute.key
      remove_resource_attribute: true
```

### Notes

While the PubSub topic doesn't require any configuration for ordering, you will need to enable ordering on your 
subscription(s) if you need it. Enabling ordering on a subscription is only possible at creation.
For composite ordering keys you'd need to compose the resource attribute value before exporting e.g., by using a
[transform processor](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/processor/transformprocessor)
.

Empty values in the ordering key are accepted but won't be ordered, see [PubSub ordering documentation](https://cloud.google.com/pubsub/docs/ordering)
for more details.

PubSub requires one publish request per ordering key value, so this exporter groups the signals per ordering key before 
publishing.
