import { Dag, DagNode } from ".";
/**
 * get a mapping from a the children of a set of nodes to their unique parents
 */
export declare function getParents<N, L>(parentNodes: Iterable<DagNode<N, L>>): Map<DagNode<N, L>, DagNode<N, L>[]>;
/**
 * get a mapping from a the children of a set of nodes to their parents with counts
 */
export declare function getParentCounts<N, L>(parentNodes: Iterable<DagNode<N, L>>): Map<DagNode<N, L>, [DagNode<N, L>, number][]>;
/** get the id from a dag node */
export interface IdAccessor<N, L> {
    (node: DagNode<N, L>): string;
}
/** convert a dag into a dot string */
export declare function dot<N, L>(dag: Dag<N, L>, id: IdAccessor<N, L>): string;
/** a node prioritization function */
export interface Prioritization<N, L> {
    (node: DagNode<N, L>): number | undefined;
}
/**
 * iterate over nodes in a dag
 *
 * Parents will be returned before children. Nodes without priority will be
 * returned first, then nodes with the lowest priority.
 */
export declare function before<N, L>(dag: Dag<N, L>, priority: Prioritization<N, L>): IterableIterator<DagNode<N, L>>;
