import { useAsync } from 'react-use';

const useAsyncDependency = (importStatement) => {
  const state = useAsync(async () => {
    return await importStatement;
  });
  return {
    ...state,
    dependency: state.value
  };
};

export { useAsyncDependency };
//# sourceMappingURL=useAsyncDependency.mjs.map
