"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.observeResourceTimings = observeResourceTimings;
var faro_core_1 = require("@grafana/faro-core");
var url_1 = require("../../utils/url");
var performanceConstants_1 = require("./performanceConstants");
var performanceUtils_1 = require("./performanceUtils");
var DEFAULT_TRACK_RESOURCES = { initiatorType: ['xmlhttprequest', 'fetch'] };
function observeResourceTimings(faroNavigationId, pushEvent, observable) {
    var trackResources = faro_core_1.faro.config.trackResources;
    var observer = new PerformanceObserver(function (observedEntries) {
        var entries = observedEntries.getEntries();
        for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
            var resourceEntryRaw = entries_1[_i];
            if ((0, url_1.isUrlIgnored)(resourceEntryRaw.name)) {
                return;
            }
            var resourceEntryJson = resourceEntryRaw.toJSON();
            var spanContext = (0, performanceUtils_1.getSpanContextFromServerTiming)(resourceEntryJson === null || resourceEntryJson === void 0 ? void 0 : resourceEntryJson.serverTiming);
            if ((trackResources == null && (0, performanceUtils_1.includePerformanceEntry)(resourceEntryJson, DEFAULT_TRACK_RESOURCES)) ||
                trackResources) {
                var faroResourceEntry = __assign(__assign({}, (0, performanceUtils_1.createFaroResourceTiming)(resourceEntryJson)), { faroNavigationId: faroNavigationId, faroResourceId: (0, faro_core_1.genShortID)() });
                if (faro_core_1.faro.config.trackUserActionsPreview) {
                    observable === null || observable === void 0 ? void 0 : observable.notify({
                        type: performanceConstants_1.RESOURCE_ENTRY,
                    });
                }
                pushEvent('faro.performance.resource', faroResourceEntry, undefined, {
                    spanContext: spanContext,
                    timestampOverwriteMs: performance.timeOrigin + resourceEntryJson.startTime,
                });
            }
        }
    });
    observer.observe({
        type: performanceConstants_1.RESOURCE_ENTRY,
        buffered: true,
    });
}
//# sourceMappingURL=resource.js.map