"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNavigationTimings = getNavigationTimings;
var faro_core_1 = require("@grafana/faro-core");
var utils_1 = require("../../utils");
var url_1 = require("../../utils/url");
var instrumentationConstants_1 = require("../instrumentationConstants");
var performanceConstants_1 = require("./performanceConstants");
var performanceUtils_1 = require("./performanceUtils");
function getNavigationTimings(pushEvent) {
    var faroNavigationEntryResolve;
    var faroNavigationEntryPromise = new Promise(function (resolve) {
        faroNavigationEntryResolve = resolve;
    });
    var observer = new PerformanceObserver(function (observedEntries) {
        var _a;
        var navigationEntryRaw = observedEntries.getEntries()[0];
        if (navigationEntryRaw == null || (0, url_1.isUrlIgnored)(navigationEntryRaw.name)) {
            return;
        }
        var navEntryJson = navigationEntryRaw.toJSON();
        var spanContext = (0, performanceUtils_1.getSpanContextFromServerTiming)(navEntryJson === null || navEntryJson === void 0 ? void 0 : navEntryJson.serverTiming);
        var faroPreviousNavigationId = (_a = (0, utils_1.getItem)(instrumentationConstants_1.NAVIGATION_ID_STORAGE_KEY, utils_1.webStorageType.session)) !== null && _a !== void 0 ? _a : faro_core_1.unknownString;
        var faroNavigationEntry = __assign(__assign({}, (0, performanceUtils_1.createFaroNavigationTiming)(navEntryJson)), { faroNavigationId: (0, faro_core_1.genShortID)(), faroPreviousNavigationId: faroPreviousNavigationId });
        (0, utils_1.setItem)(instrumentationConstants_1.NAVIGATION_ID_STORAGE_KEY, faroNavigationEntry.faroNavigationId, utils_1.webStorageType.session);
        pushEvent('faro.performance.navigation', faroNavigationEntry, undefined, {
            spanContext: spanContext,
            timestampOverwriteMs: performance.timeOrigin + navEntryJson.startTime,
        });
        faroNavigationEntryResolve(faroNavigationEntry);
    });
    observer.observe({
        type: performanceConstants_1.NAVIGATION_ENTRY,
        buffered: true,
    });
    return faroNavigationEntryPromise;
}
//# sourceMappingURL=navigation.js.map