"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDataFromSafariExtensions = getDataFromSafariExtensions;
var const_1 = require("./const");
function getDataFromSafariExtensions(func, filename) {
    var isSafariExtension = func === null || func === void 0 ? void 0 : func.includes(const_1.safariExtensionString);
    var isSafariWebExtension = !isSafariExtension && (func === null || func === void 0 ? void 0 : func.includes(const_1.safariWebExtensionString));
    if (!isSafariExtension && !isSafariWebExtension) {
        return [func, filename];
    }
    return [
        (func === null || func === void 0 ? void 0 : func.includes(const_1.atString)) ? func.split(const_1.atString)[0] : func,
        isSafariExtension ? "".concat(const_1.safariExtensionString, ":").concat(filename) : "".concat(const_1.safariWebExtensionString, ":").concat(filename),
    ];
}
//# sourceMappingURL=getDataFromSafariExtensions.js.map