"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.CSPInstrumentation = void 0;
var faro_core_1 = require("@grafana/faro-core");
var CSPInstrumentation = /** @class */ (function (_super) {
    __extends(CSPInstrumentation, _super);
    function CSPInstrumentation() {
        var _this = _super.call(this) || this;
        _this.name = '@grafana/faro-web-sdk:instrumentation-csp';
        _this.version = faro_core_1.VERSION;
        return _this;
    }
    CSPInstrumentation.prototype.initialize = function () {
        document.addEventListener('securitypolicyviolation', this.securitypolicyviolationHandler.bind(this));
    };
    CSPInstrumentation.prototype.destroy = function () {
        document.removeEventListener('securitypolicyviolation', this.securitypolicyviolationHandler);
    };
    CSPInstrumentation.prototype.securitypolicyviolationHandler = function (ev) {
        this.api.pushEvent('securitypolicyviolation', (0, faro_core_1.stringifyObjectValues)(ev));
    };
    return CSPInstrumentation;
}(faro_core_1.BaseInstrumentation));
exports.CSPInstrumentation = CSPInstrumentation;
//# sourceMappingURL=instrumentation.js.map