"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPromiseBuffer = createPromiseBuffer;
function createPromiseBuffer(options) {
    var size = options.size, concurrency = options.concurrency;
    var buffer = []; // pending, not-yet-started tasks
    var inProgress = 0; // counter for tasks currently in progress
    var work = function () {
        // if there's space for a task and buffer is not empty,
        // take one task from buffer and run it
        if (inProgress < concurrency && buffer.length) {
            var _a = buffer.shift(), producer = _a.producer, resolve_1 = _a.resolve, reject_1 = _a.reject;
            inProgress++;
            producer().then(function (result) {
                inProgress--;
                work();
                resolve_1(result);
            }, function (reason) {
                inProgress--;
                work();
                reject_1(reason);
            });
        }
    };
    var add = function (promiseProducer) {
        if (buffer.length + inProgress >= size) {
            throw new Error('Task buffer full');
        }
        return new Promise(function (resolve, reject) {
            buffer.push({
                producer: promiseProducer,
                resolve: resolve,
                reject: reject,
            });
            work();
        });
    };
    return {
        add: add,
    };
}
//# sourceMappingURL=promiseBuffer.js.map