"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var json_1 = require("./json");
describe('json', function () {
    it('replace circular references with null value', function () {
        var replacer = (0, json_1.getCircularDependencyReplacer)();
        var obj = { a: 1 };
        obj.circular = obj;
        expect(JSON.stringify(obj, replacer)).toBe('{"a":1,"circular":null}');
    });
    it('stringifyExternalJson function replaces circular references with null value', function () {
        var obj = { a: 1 };
        obj.circular = obj;
        expect((0, json_1.stringifyExternalJson)(obj)).toBe('{"a":1,"circular":null}');
    });
    it('stringifyObjectValues function stringifies object values', function () {
        var obj = { a: 1, b: { c: 2 }, d: 'foo', e: true, f: [true, 'a', 1], g: null };
        var objectWithStringifiedValues = (0, json_1.stringifyObjectValues)(obj);
        expect(objectWithStringifiedValues).toStrictEqual({
            a: '1',
            b: '{"c":2}',
            d: 'foo',
            e: 'true',
            f: '[true,\"a\",1]',
            g: 'null',
        });
        Object.values(objectWithStringifiedValues).forEach(function (key) {
            expect(typeof key).toBe('string');
        });
    });
    it('stringifyObjectValues function return an empty object if parameter is undefined', function () {
        expect((0, json_1.stringifyObjectValues)()).toStrictEqual({});
    });
});
//# sourceMappingURL=json.test.js.map