"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeResourceSpans = mergeResourceSpans;
exports.getTransportBody = getTransportBody;
var const_1 = require("./const");
function mergeResourceSpans(traces, resourceSpans) {
    var _a, _b;
    if (resourceSpans === undefined) {
        return traces;
    }
    if (traces === undefined) {
        return {
            resourceSpans: resourceSpans,
        };
    }
    var currentResource = (_a = traces.resourceSpans) === null || _a === void 0 ? void 0 : _a[0];
    if (currentResource === undefined) {
        return traces;
    }
    var currentSpans = (currentResource === null || currentResource === void 0 ? void 0 : currentResource.scopeSpans) || [];
    var newSpans = ((_b = resourceSpans === null || resourceSpans === void 0 ? void 0 : resourceSpans[0]) === null || _b === void 0 ? void 0 : _b.scopeSpans) || [];
    return __assign(__assign({}, traces), { resourceSpans: [
            __assign(__assign({}, currentResource), { scopeSpans: __spreadArray(__spreadArray([], currentSpans, true), newSpans, true) }),
        ] });
}
function getTransportBody(item) {
    var body = {
        meta: {},
    };
    if (item[0] !== undefined) {
        body.meta = item[0].meta;
    }
    item.forEach(function (currentItem) {
        var _a;
        switch (currentItem.type) {
            case const_1.TransportItemType.LOG:
            case const_1.TransportItemType.EVENT:
            case const_1.TransportItemType.EXCEPTION:
            case const_1.TransportItemType.MEASUREMENT:
                var bk = const_1.transportItemTypeToBodyKey[currentItem.type];
                var signals = body[bk];
                body = __assign(__assign({}, body), (_a = {}, _a[bk] = signals === undefined ? [currentItem.payload] : __spreadArray(__spreadArray([], signals, true), [currentItem.payload], false), _a));
                break;
            case const_1.TransportItemType.TRACE:
                body = __assign(__assign({}, body), { traces: mergeResourceSpans(body.traces, currentItem.payload.resourceSpans) });
                break;
        }
    });
    return body;
}
//# sourceMappingURL=utils.js.map