"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUserActionLifecycleHandler = createUserActionLifecycleHandler;
var transports_1 = require("../transports");
var const_1 = require("./const");
var ItemBuffer_1 = require("./ItemBuffer");
function createUserActionLifecycleHandler(_a) {
    var apiMessageBus = _a.apiMessageBus, transports = _a.transports, config = _a.config;
    var actionBuffer = new ItemBuffer_1.ItemBuffer();
    var trackUserActionsExcludeItem = config.trackUserActionsExcludeItem;
    var message;
    apiMessageBus.subscribe(function (msg) {
        if (const_1.USER_ACTION_START === msg.type || const_1.USER_ACTION_HALT === msg.type) {
            message = msg;
            return;
        }
        if (msg.type === const_1.USER_ACTION_END) {
            var id_1 = msg.id, name_1 = msg.name;
            actionBuffer.flushBuffer(function (item) {
                if (isExcludeFromUserAction(item, trackUserActionsExcludeItem)) {
                    transports.execute(item);
                    return;
                }
                var userActionItem = __assign(__assign({}, item), { payload: __assign(__assign({}, item.payload), { action: {
                            parentId: id_1,
                            name: name_1,
                        } }) });
                transports.execute(userActionItem);
            });
            message = undefined;
            return;
        }
        if (msg.type === const_1.USER_ACTION_CANCEL) {
            message = undefined;
            actionBuffer.flushBuffer(function (item) {
                transports.execute(item);
            });
        }
    });
    var getMessage = function () { return message; };
    return { actionBuffer: actionBuffer, getMessage: getMessage };
}
function isExcludeFromUserAction(item, trackUserActionsExcludeItem) {
    return ((trackUserActionsExcludeItem === null || trackUserActionsExcludeItem === void 0 ? void 0 : trackUserActionsExcludeItem(item)) ||
        (item.type === transports_1.TransportItemType.MEASUREMENT && item.payload.type === 'web-vitals'));
}
//# sourceMappingURL=userActionLifecycleHandler.js.map