import { TransportItemType } from '../transports';
import { USER_ACTION_CANCEL, USER_ACTION_END, USER_ACTION_HALT, USER_ACTION_START } from './const';
import { ItemBuffer } from './ItemBuffer';
export function createUserActionLifecycleHandler({ apiMessageBus, transports, config, }) {
    const actionBuffer = new ItemBuffer();
    const trackUserActionsExcludeItem = config.trackUserActionsExcludeItem;
    let message;
    apiMessageBus.subscribe((msg) => {
        if (USER_ACTION_START === msg.type || USER_ACTION_HALT === msg.type) {
            message = msg;
            return;
        }
        if (msg.type === USER_ACTION_END) {
            const { id, name } = msg;
            actionBuffer.flushBuffer((item) => {
                if (isExcludeFromUserAction(item, trackUserActionsExcludeItem)) {
                    transports.execute(item);
                    return;
                }
                const userActionItem = Object.assign(Object.assign({}, item), { payload: Object.assign(Object.assign({}, item.payload), { action: {
                            parentId: id,
                            name,
                        } }) });
                transports.execute(userActionItem);
            });
            message = undefined;
            return;
        }
        if (msg.type === USER_ACTION_CANCEL) {
            message = undefined;
            actionBuffer.flushBuffer((item) => {
                transports.execute(item);
            });
        }
    });
    const getMessage = () => message;
    return { actionBuffer, getMessage };
}
function isExcludeFromUserAction(item, trackUserActionsExcludeItem) {
    return ((trackUserActionsExcludeItem === null || trackUserActionsExcludeItem === void 0 ? void 0 : trackUserActionsExcludeItem(item)) ||
        (item.type === TransportItemType.MEASUREMENT && item.payload.type === 'web-vitals'));
}
//# sourceMappingURL=userActionLifecycleHandler.js.map