import { TransportItemType } from '../../transports';
import { deepEqual, getCurrentTimestamp, isEmpty, isNull, stringifyObjectValues } from '../../utils';
import { timestampToIsoString } from '../../utils/date';
import { USER_ACTION_START } from '../const';
export function initializeEventsAPI({ internalLogger, config, metas, transports, tracesApi, actionBuffer, getMessage, }) {
    let lastPayload = null;
    const pushEvent = (name, attributes, domain, { skipDedupe, spanContext, timestampOverwriteMs, customPayloadTransformer = (payload) => payload } = {}) => {
        try {
            const attrs = stringifyObjectValues(attributes);
            const item = {
                meta: metas.value,
                payload: customPayloadTransformer({
                    name,
                    domain: domain !== null && domain !== void 0 ? domain : config.eventDomain,
                    attributes: isEmpty(attrs) ? undefined : attrs,
                    timestamp: timestampOverwriteMs ? timestampToIsoString(timestampOverwriteMs) : getCurrentTimestamp(),
                    trace: spanContext
                        ? {
                            trace_id: spanContext.traceId,
                            span_id: spanContext.spanId,
                        }
                        : tracesApi.getTraceContext(),
                }),
                type: TransportItemType.EVENT,
            };
            const testingPayload = {
                name: item.payload.name,
                attributes: item.payload.attributes,
                domain: item.payload.domain,
            };
            if (!skipDedupe && config.dedupe && !isNull(lastPayload) && deepEqual(testingPayload, lastPayload)) {
                internalLogger.debug('Skipping event push because it is the same as the last one\n', item.payload);
                return;
            }
            lastPayload = testingPayload;
            internalLogger.debug('Pushing event\n', item);
            const msg = getMessage();
            if (msg && msg.type === USER_ACTION_START) {
                actionBuffer.addItem(item);
            }
            else {
                transports.execute(item);
            }
        }
        catch (err) {
            internalLogger.error('Error pushing event', err);
        }
    };
    return {
        pushEvent,
    };
}
//# sourceMappingURL=initialize.js.map