"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSyntheticEvent = exports.isMap = exports.isMapDefined = exports.isElement = exports.isElementDefined = exports.isDomException = exports.isDomError = exports.isErrorEvent = exports.isError = exports.isErrorDefined = exports.isEvent = exports.isEventDefined = exports.isPrimitive = exports.isThenable = exports.isRegExp = exports.isArray = exports.isFunction = exports.isObject = exports.isSymbol = exports.isBoolean = exports.isInt = exports.isNumber = exports.isString = exports.isNull = exports.isUndefined = void 0;
exports.isTypeof = isTypeof;
exports.isToString = isToString;
exports.isInstanceOf = isInstanceOf;
exports.isEmpty = isEmpty;
function isTypeof(value, type) {
    return typeof value === type;
}
function isToString(value, type) {
    return Object.prototype.toString.call(value) === "[object ".concat(type, "]");
}
function isInstanceOf(value, reference) {
    try {
        return value instanceof reference;
    }
    catch (err) {
        return false;
    }
}
exports.isUndefined = (function (value) { return isTypeof(value, 'undefined'); });
exports.isNull = (function (value) { return isTypeof(value, 'null'); });
exports.isString = (function (value) { return isTypeof(value, 'string'); });
exports.isNumber = (function (value) {
    return (isTypeof(value, 'number') && !isNaN(value)) || isTypeof(value, 'bigint');
});
exports.isInt = (function (value) { return (0, exports.isNumber)(value) && Number.isInteger(value); });
exports.isBoolean = (function (value) { return isTypeof(value, 'boolean'); });
exports.isSymbol = (function (value) { return isTypeof(value, 'symbol'); });
exports.isObject = (function (value) { return !(0, exports.isNull)(value) && isTypeof(value, 'object'); });
exports.isFunction = (function (value) { return isTypeof(value, 'function'); });
exports.isArray = (function (value) { return isToString(value, 'Array'); });
exports.isRegExp = (function (value) { return isToString(value, 'RegExp'); });
exports.isThenable = (function (value) { return (0, exports.isFunction)(value === null || value === void 0 ? void 0 : value.then); });
exports.isPrimitive = (function (value) { return !(0, exports.isObject)(value) && !(0, exports.isFunction)(value); });
exports.isEventDefined = typeof Event !== 'undefined';
exports.isEvent = (function (value) { return exports.isEventDefined && isInstanceOf(value, Event); });
exports.isErrorDefined = typeof Error !== 'undefined';
exports.isError = (function (value) { return exports.isErrorDefined && isInstanceOf(value, Error); });
exports.isErrorEvent = (function (value) { return isToString(value, 'ErrorEvent'); });
exports.isDomError = (function (value) { return isToString(value, 'DOMError'); });
exports.isDomException = (function (value) { return isToString(value, 'DOMException'); });
exports.isElementDefined = typeof Element !== 'undefined';
exports.isElement = (function (value) { return exports.isElementDefined && isInstanceOf(value, Element); });
exports.isMapDefined = typeof Map !== 'undefined';
exports.isMap = (function (value) { return exports.isMapDefined && isInstanceOf(value, Map); });
exports.isSyntheticEvent = (function (value) {
    return (0, exports.isObject)(value) &&
        'nativeEvent' in value &&
        'preventDefault' in value &&
        'stopPropagation' in value;
});
function isEmpty(value) {
    if (value == null) {
        return true;
    }
    if ((0, exports.isArray)(value) || (0, exports.isString)(value)) {
        return value.length === 0;
    }
    if ((0, exports.isObject)(value)) {
        return Object.keys(value).length === 0;
    }
    return false;
}
//# sourceMappingURL=is.js.map