#!/bin/bash

REPORT_DB_NAME=reportdb

run_sql() {
    PGHOST= PGHOSTADDR= psql -v ON_ERROR_STOP=1 -U "$POSTGRES_USER" --no-password --no-psqlrc "$@"
}

echo "CREATE DATABASE $REPORT_DB_NAME ENCODING = UTF8 ;" | run_sql
echo "CREATE ROLE $REPORT_DB_USER PASSWORD '$REPORT_DB_PASS' NOSUPERUSER NOCREATEDB CREATEROLE INHERIT LOGIN;" | run_sql -d $REPORT_DB_NAME
echo "GRANT ALL PRIVILEGES ON DATABASE $REPORT_DB_NAME TO $REPORT_DB_USER;" | run_sql -d $REPORT_DB_NAME
echo "ALTER DATABASE $REPORT_DB_NAME OWNER TO $REPORT_DB_USER;" | run_sql -d $REPORT_DB_NAME
echo "GRANT ALL PRIVILEGES ON SCHEMA public TO $REPORT_DB_USER;" | run_sql -d $REPORT_DB_NAME
