/*
 * livepatch_bsc1248298
 *
 * Fix for CVE-2025-38555, bsc#1248298
 *
 *  Upstream commit:
 *  151c0aa896c4 ("usb: gadget : fix use-after-free in composite_dev_cleanup()")
 *
 *  SLE12-SP5 commit:
 *  Not affected
 *
 *  SLE15-SP3 commit:
 *  Not affected
 *
 *  SLE15-SP4 and -SP5 commit:
 *  d29d36aa8e634808a1ee399f8f614e1c19e99c75
 *
 *  SLE15-SP6 commit:
 *  e4ac187a4b8a3bbcde0c6716cca8f4fbbeb1d9ae
 *
 *  SLE MICRO-6-0 commit:
 *  e4ac187a4b8a3bbcde0c6716cca8f4fbbeb1d9ae
 *
 *  Copyright (c) 2025 SUSE
 *  Author: Lidong Zhong <lidong.zhong@suse.com>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#if IS_ENABLED(CONFIG_USB_LIBCOMPOSITE)

/* klp-ccp: from drivers/usb/gadget/composite.c */
#include <linux/kallsyms.h>
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/device.h>

#include <linux/usb/composite.h>

/* klp-ccp: from include/asm-generic/unaligned.h */
#define __ASM_GENERIC_UNALIGNED_H

/* klp-ccp: from drivers/usb/gadget/u_os_desc.h */
#include <asm/unaligned.h>

/* klp-ccp: from drivers/usb/gadget/composite.c */
static void (*klpe_composite_setup_complete)(struct usb_ep *ep, struct usb_request *req);

int klpp_composite_os_desc_req_prepare(struct usb_composite_dev *cdev,
				  struct usb_ep *ep0)
{
	int ret = 0;

	cdev->os_desc_req = usb_ep_alloc_request(ep0, GFP_KERNEL);
	if (!cdev->os_desc_req) {
		ret = -ENOMEM;
		goto end;
	}

	cdev->os_desc_req->buf = kmalloc(USB_COMP_EP0_OS_DESC_BUFSIZ,
					 GFP_KERNEL);
	if (!cdev->os_desc_req->buf) {
		ret = -ENOMEM;
		usb_ep_free_request(ep0, cdev->os_desc_req);
		/*
		 * Set os_desc_req to NULL so that composite_dev_cleanup()
		 * will not try to free it again.
		 */
		cdev->os_desc_req = NULL;
		goto end;
	}
	cdev->os_desc_req->context = cdev;
	cdev->os_desc_req->complete = (*klpe_composite_setup_complete);
end:
	return ret;
}


#include "livepatch_bsc1248298.h"

#include <linux/kernel.h>
#include <linux/module.h>
#include "../kallsyms_relocs.h"

#define LP_MODULE "libcomposite"

static struct klp_kallsyms_reloc klp_funcs[] = {
	{ "composite_setup_complete", (void *)&klpe_composite_setup_complete,
	  "libcomposite" },
};

static int module_notify(struct notifier_block *nb,
			unsigned long action, void *data)
{
	struct module *mod = data;
	int ret;

	if (action != MODULE_STATE_COMING || strcmp(mod->name, LP_MODULE))
		return 0;
	ret = klp_resolve_kallsyms_relocs(klp_funcs, ARRAY_SIZE(klp_funcs));

	WARN(ret, "%s: delayed kallsyms lookup failed. System is broken and can crash.\n",
		__func__);

	return ret;
}

static struct notifier_block module_nb = {
	.notifier_call = module_notify,
	.priority = INT_MIN+1,
};

int livepatch_bsc1248298_init(void)
{
	int ret;
	struct module *mod;

	ret = klp_kallsyms_relocs_init();
	if (ret)
		return ret;

	ret = register_module_notifier(&module_nb);
	if (ret)
		return ret;

	rcu_read_lock_sched();
	mod = (*klpe_find_module)(LP_MODULE);
	if (!try_module_get(mod))
		mod = NULL;
	rcu_read_unlock_sched();

	if (mod) {
		ret = klp_resolve_kallsyms_relocs(klp_funcs,
						ARRAY_SIZE(klp_funcs));
	}

	if (ret)
		unregister_module_notifier(&module_nb);
	module_put(mod);

	return ret;
}

void livepatch_bsc1248298_cleanup(void)
{
	unregister_module_notifier(&module_nb);
}

#endif /* IS_ENABLED(CONFIG_USB_LIBCOMPOSITE) */
