[comment]: <> (Code generated by mdatagen. DO NOT EDIT.)

# vcenter

## Default Metrics

The following metrics are emitted by default. Each of them can be disabled by applying the following configuration:

```yaml
metrics:
  <metric_name>:
    enabled: false
```

### vcenter.cluster.cpu.effective

The effective CPU available to the cluster. This value excludes CPU from hosts in maintenance mode or are unresponsive.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MHz | Sum | Int | Cumulative | false | Development |

### vcenter.cluster.cpu.limit

The amount of CPU available to the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MHz | Sum | Int | Cumulative | false | Development |

### vcenter.cluster.host.count

The number of hosts in the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {hosts} | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| effective | Whether the host is effective in the vCenter cluster. | Any Bool | Recommended |

### vcenter.cluster.memory.effective

The effective available memory of the cluster.

This value excludes memory from hosts that are either in maintenance mode or are unresponsive. It also excludes memory used by the VMware Service Console.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| By | Sum | Int | Cumulative | false | Development |

### vcenter.cluster.memory.limit

The available memory of the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| By | Sum | Int | Cumulative | false | Development |

### vcenter.cluster.vm.count

The number of virtual machines in the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {virtual_machines} | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| power_state | The current power state of the virtual machine. | Str: ``on``, ``off``, ``suspended``, ``unknown`` | Recommended |

### vcenter.cluster.vm_template.count

The number of virtual machine templates in the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {virtual_machine_templates} | Sum | Int | Cumulative | false | Development |

### vcenter.cluster.vsan.congestions

The congestions of IOs generated by all vSAN clients in the cluster.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {congestions/s} | Gauge | Double | Development |

### vcenter.cluster.vsan.latency.avg

The overall cluster latency while accessing vSAN storage.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| us | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN latency. | Str: ``read``, ``write`` | Recommended |

### vcenter.cluster.vsan.operations

The vSAN IOPs of a cluster.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {operations/s} | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN operation. | Str: ``read``, ``write``, ``unmap`` | Recommended |

### vcenter.cluster.vsan.throughput

The vSAN throughput of a cluster.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| By/s | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The type of vSAN throughput. | Str: ``read``, ``write`` | Recommended |

### vcenter.datacenter.cluster.count

The number of clusters in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {clusters} | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| status | The current status of the managed entity. | Str: ``red``, ``yellow``, ``green``, ``gray`` | Recommended |

### vcenter.datacenter.cpu.limit

The total amount of CPU available to the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MHz | Sum | Int | Cumulative | false | Development |

### vcenter.datacenter.datastore.count

The number of datastores in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {datastores} | Sum | Int | Cumulative | false | Development |

### vcenter.datacenter.disk.space

The amount of available and used disk space in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| By | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| disk_state | The state of storage and whether it is already allocated or free. | Str: ``available``, ``used`` | Recommended |

### vcenter.datacenter.host.count

The number of hosts in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {hosts} | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| status | The current status of the managed entity. | Str: ``red``, ``yellow``, ``green``, ``gray`` | Recommended |
| power_state | The current power state of the host. | Str: ``on``, ``off``, ``standby``, ``unknown`` | Recommended |

### vcenter.datacenter.memory.limit

The total amount of memory available to the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| By | Sum | Int | Cumulative | false | Development |

### vcenter.datacenter.vm.count

The number of VM's in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {virtual_machines} | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| status | The current status of the managed entity. | Str: ``red``, ``yellow``, ``green``, ``gray`` | Recommended |
| power_state | The current power state of the virtual machine. | Str: ``on``, ``off``, ``suspended``, ``unknown`` | Recommended |

### vcenter.datastore.disk.usage

The amount of space in the datastore.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| By | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| disk_state | The state of storage and whether it is already allocated or free. | Str: ``available``, ``used`` | Recommended |

### vcenter.datastore.disk.utilization

The utilization of the datastore.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| % | Gauge | Double | Development |

### vcenter.host.cpu.capacity

Total CPU capacity of the host system.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MHz | Sum | Int | Cumulative | false | Development |

### vcenter.host.cpu.reserved

The CPU of the host reserved for use by virtual machines.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MHz | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| cpu_reservation_type | The type of CPU reservation for the host. | Str: ``total``, ``used`` | Recommended |

### vcenter.host.cpu.usage

The amount of CPU used by the host.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MHz | Sum | Int | Cumulative | false | Development |

### vcenter.host.cpu.utilization

The CPU utilization of the host system.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| % | Gauge | Double | Development |

### vcenter.host.disk.latency.avg

The latency of operations to the host system's disk.

This latency is the sum of the device and kernel read and write latencies. Requires Performance Counter level 2 for metric to populate.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| ms | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of disk latency. | Str: ``read``, ``write`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.host.disk.latency.max

Highest latency value across all disks used by the host.

As measured over the most recent 20s interval. Requires Performance Level 3.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| ms | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.host.disk.throughput

Average number of kilobytes read from or written to the disk each second.

As measured over the most recent 20s interval. Aggregated disk I/O rate. Requires Performance Level 4.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {KiBy/s} | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of disk latency. | Str: ``read``, ``write`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.host.memory.usage

The amount of memory the host system is using.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Int | Cumulative | false | Development |

### vcenter.host.memory.utilization

The percentage of the host system's memory capacity that is being utilized.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| % | Gauge | Double | Development |

### vcenter.host.network.packet.drop.rate

The rate of packets dropped across each physical NIC (network interface controller) instance on the host.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {packets/s} | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.host.network.packet.error.rate

The rate of packet errors transmitted or received on the host network.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {errors/s} | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.host.network.packet.rate

The rate of packets transmitted or received across each physical NIC (network interface controller) instance on the host.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {packets/s} | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.host.network.throughput

The amount of data that was transmitted or received over the network by the host.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {KiBy/s} | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.host.network.usage

The sum of the data transmitted and received for all the NIC instances of the host.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {KiBy/s} | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.host.vsan.cache.hit_rate

The host's read IOs which could be satisfied by the local client cache.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| % | Gauge | Int | Development |

### vcenter.host.vsan.congestions

The congestions of IOs generated by all vSAN clients in the host.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {congestions/s} | Gauge | Double | Development |

### vcenter.host.vsan.latency.avg

The host latency while accessing vSAN storage.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| us | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN latency. | Str: ``read``, ``write`` | Recommended |

### vcenter.host.vsan.operations

The vSAN IOPs of a host.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {operations/s} | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN operation. | Str: ``read``, ``write``, ``unmap`` | Recommended |

### vcenter.host.vsan.throughput

The vSAN throughput of a host.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| By/s | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The type of vSAN throughput. | Str: ``read``, ``write`` | Recommended |

### vcenter.resource_pool.cpu.shares

The amount of shares of CPU in the resource pool.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {shares} | Sum | Int | Cumulative | false | Development |

### vcenter.resource_pool.cpu.usage

The usage of the CPU used by the resource pool.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MHz | Sum | Int | Cumulative | false | Development |

### vcenter.resource_pool.memory.ballooned

The amount of memory in a resource pool that is ballooned due to virtualization.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Int | Cumulative | false | Development |

### vcenter.resource_pool.memory.granted

The amount of memory that is granted to VMs in the resource pool from shared and non-shared host memory.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| type | The type of memory granted. | Str: ``private``, ``shared`` | Recommended |

### vcenter.resource_pool.memory.shares

The amount of shares of memory in the resource pool.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {shares} | Sum | Int | Cumulative | false | Development |

### vcenter.resource_pool.memory.swapped

The amount of memory that is granted to VMs in the resource pool from the host's swap space.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Int | Cumulative | false | Development |

### vcenter.resource_pool.memory.usage

The usage of the memory by the resource pool.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| type | The type of memory usage. | Str: ``guest``, ``host``, ``overhead`` | Recommended |

### vcenter.vm.cpu.readiness

Percentage of time that the virtual machine was ready, but could not get scheduled to run on the physical CPU.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| % | Gauge | Int | Development |

### vcenter.vm.cpu.usage

The amount of CPU used by the VM.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MHz | Sum | Int | Cumulative | false | Development |

### vcenter.vm.cpu.utilization

The CPU utilization of the VM.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| % | Gauge | Double | Development |

### vcenter.vm.disk.latency.avg

The latency of operations to the virtual machine's disk.

Requires Performance Counter level 2 for metric to populate. As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| ms | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of disk latency. | Str: ``read``, ``write`` | Recommended |
| disk_type | The type of storage device that is being recorded. | Str: ``virtual``, ``physical`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.vm.disk.latency.max

The highest reported total latency (device and kernel times) over an interval of 20 seconds.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| ms | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.vm.disk.throughput

Average number of kilobytes read from or written to the virtual disk each second.

As measured over the most recent 20s interval. Requires Performance Level 2.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {KiBy/s} | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of disk latency. | Str: ``read``, ``write`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.vm.disk.usage

The amount of storage space used by the virtual machine.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| By | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| disk_state | The state of storage and whether it is already allocated or free. | Str: ``available``, ``used`` | Recommended |

### vcenter.vm.disk.utilization

The utilization of storage on the virtual machine.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| % | Gauge | Double | Development |

### vcenter.vm.memory.ballooned

The amount of memory that is ballooned due to virtualization.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Int | Cumulative | false | Development |

### vcenter.vm.memory.swapped

The portion of memory that is granted to this VM from the host's swap space.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Int | Cumulative | false | Development |

### vcenter.vm.memory.swapped_ssd

The amount of memory swapped to fast disk device such as SSD.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| KiBy | Sum | Int | Cumulative | false | Development |

### vcenter.vm.memory.usage

The amount of memory that is used by the virtual machine.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Int | Cumulative | false | Development |

### vcenter.vm.memory.utilization

The memory utilization of the VM.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| % | Gauge | Double | Development |

### vcenter.vm.network.packet.drop.rate

The rate of transmitted or received packets dropped by each vNIC (virtual network interface controller) on the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {packets/s} | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.vm.network.packet.rate

The rate of packets transmitted or received by each vNIC (virtual network interface controller) on the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {packets/s} | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.vm.network.throughput

The amount of data that was transmitted or received over the network of the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| By/s | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.vm.network.usage

The network utilization combined transmit and receive rates during an interval.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| {KiBy/s} | Sum | Int | Cumulative | false | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.vm.vsan.latency.avg

The virtual machine latency while accessing vSAN storage.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| us | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN latency. | Str: ``read``, ``write`` | Recommended |

### vcenter.vm.vsan.operations

The vSAN IOPs of a virtual machine.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {operations/s} | Gauge | Int | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN operation. | Str: ``read``, ``write``, ``unmap`` | Recommended |

### vcenter.vm.vsan.throughput

The vSAN throughput of a virtual machine.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| By/s | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The type of vSAN throughput. | Str: ``read``, ``write`` | Recommended |

## Optional Metrics

The following metrics are not emitted by default. Each of them can be enabled by applying the following configuration:

```yaml
metrics:
  <metric_name>:
    enabled: true
```

### vcenter.host.memory.capacity

Total memory  capacity of the host system.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Double | Cumulative | false | Development |

### vcenter.vm.cpu.time

CPU time spent in idle, ready or wait state.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| % | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| cpu_state | CPU time spent in idle, ready or idle state. | Str: ``idle``, ``ready``, ``wait`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.vm.memory.granted

The amount of memory that is granted to a VM.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic | Stability |
| ---- | ----------- | ---------- | ----------------------- | --------- | --------- |
| MiBy | Sum | Int | Cumulative | false | Development |

### vcenter.vm.network.broadcast.packet.rate

The rate of broadcast packets transmitted or received by each vNIC (virtual network interface controller) on the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {packets/s} | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

### vcenter.vm.network.multicast.packet.rate

The rate of multicast packets transmitted or received by each vNIC (virtual network interface controller) on the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| {packets/s} | Gauge | Double | Development |

#### Attributes

| Name | Description | Values | Requirement Level |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | Recommended |
| object | The object on the virtual machine or host that is being reported on. | Any Str | Recommended |

## Resource Attributes

| Name | Description | Values | Enabled |
| ---- | ----------- | ------ | ------- |
| vcenter.cluster.name | The name of the vCenter cluster. | Any Str | true |
| vcenter.datacenter.name | The name of the vCenter datacenter. | Any Str | true |
| vcenter.datastore.name | The name of the vCenter datastore. | Any Str | true |
| vcenter.host.name | The hostname of the vCenter ESXi host. | Any Str | true |
| vcenter.resource_pool.inventory_path | The inventory path of the resource pool. | Any Str | true |
| vcenter.resource_pool.name | The name of the resource pool. | Any Str | true |
| vcenter.virtual_app.inventory_path | The inventory path of the vApp. | Any Str | true |
| vcenter.virtual_app.name | The name of the vApp. | Any Str | true |
| vcenter.vm.id | The instance UUID of the virtual machine. | Any Str | true |
| vcenter.vm.name | The name of the virtual machine. | Any Str | true |
| vcenter.vm_template.id | The instance UUID of the virtual machine template. | Any Str | true |
| vcenter.vm_template.name | The name of the virtual machine template. | Any Str | true |
