# Fluent Forward Receiver

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [beta]: logs   |
| Distributions | [contrib], [k8s] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Areceiver%2Ffluentforward%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Areceiver%2Ffluentforward) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Areceiver%2Ffluentforward%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Areceiver%2Ffluentforward) |
| Code coverage | [![codecov](https://codecov.io/github/open-telemetry/opentelemetry-collector-contrib/graph/main/badge.svg?component=receiver_fluentforward)](https://app.codecov.io/gh/open-telemetry/opentelemetry-collector-contrib/tree/main/?components%5B0%5D=receiver_fluentforward&displayType=list) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@dmitryax](https://www.github.com/dmitryax) |

[beta]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#beta
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
[k8s]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-k8s
<!-- end autogenerated section -->

This receiver runs a TCP server that accepts events via the [Fluent Forward
protocol](https://github.com/fluent/fluentd/wiki/Forward-Protocol-Specification-v1).

This receiver:

 - Does **not** support TLS or the handshake portion of the Forward protocol.
 - Does support acknowledgments of events that have the `chunk` option, as per the spec.
 - Supports all three event types (message, forward, packed forward, including
   compressed packed forward)
 - Supports listening on a Unix domain socket by making the `listenAddress`
   option of the form `unix://<path to socket>`.
 - If using TCP, it will start a UDP server on the same port to deliver
   heartbeat echos, as per the spec.

Here is a basic example config that makes the receiver listen on all interfaces
on port 8006:

```yaml
receivers:
  fluentforward:
    endpoint: 0.0.0.0:8006
```


## Development

If you are working on this receiver and need to regenerate any of the message
pack autogenerated code, just run `go generate` on this package and its
subpackages.  You can get the `msgp` binary by just running `go get -u -t
github.com/tinylib/msgp`, and make sure the Go binary path is on your shell's
PATH.

