export let useControlPropsValidator: typeof noop;
export function useScrollIntoView({ highlightedIndex, isOpen, itemRefs, getItemNodeFromIndex, menuElement, scrollIntoView: scrollIntoViewProp, }: {
    highlightedIndex: any;
    isOpen: any;
    itemRefs: any;
    getItemNodeFromIndex: any;
    menuElement: any;
    scrollIntoView: any;
}): React.MutableRefObject<boolean>;
/**
 * Debounced call for updating the a11y message.
 */
export const updateA11yStatus: Function;
export function useGetterPropsCalledChecker(): typeof noop;
/**
 * Tracks mouse and touch events, such as mouseDown, touchMove and touchEnd.
 *
 * @param {Window} environment The environment to add the event listeners to, for instance window.
 * @param {() => void} handleBlur The function that is called if mouseDown or touchEnd occured outside the downshiftElements.
 * @param {Array<{current: HTMLElement}>} downshiftElementsRefs The refs for the elements that should not trigger a blur action from mouseDown or touchEnd.
 * @returns {{isMouseDown: boolean, isTouchMove: boolean, isTouchEnd: boolean}} The mouse and touch events information, if any of are happening.
 */
export function useMouseAndTouchTracker(environment: Window, handleBlur: () => void, downshiftRefs: any): {
    isMouseDown: boolean;
    isTouchMove: boolean;
    isTouchEnd: boolean;
};
export function getHighlightedIndexOnOpen(props: any, state: any, offset: any): any;
export function getInitialState(props: any): {
    highlightedIndex: any;
    isOpen: any;
    selectedItem: any;
    inputValue: any;
};
export function getInitialValue(props: any, propKey: any, defaultStateValues?: {
    highlightedIndex: number;
    isOpen: boolean;
    selectedItem: null;
    inputValue: string;
}): any;
export function getDefaultValue(props: any, propKey: any, defaultStateValues?: {
    highlightedIndex: number;
    isOpen: boolean;
    selectedItem: null;
    inputValue: string;
}): any;
export namespace defaultProps {
    export function itemToString(item: any): string;
    export function itemToKey(item: any): any;
    export { stateReducer };
    export { scrollIntoView };
    export const environment: (Window & typeof globalThis) | undefined;
}
/**
 * Wraps the useEnhancedReducer and applies the controlled prop values before
 * returning the new state.
 *
 * @param {Function} reducer Reducer function from downshift.
 * @param {Object} props The hook props, also passed to createInitialState.
 * @param {Function} createInitialState Function that returns the initial state.
 * @param {Function} isStateEqual Function that checks if a previous state is equal to the next.
 * @returns {Array} An array with the state and an action dispatcher.
 */
export function useControlledReducer(reducer: Function, props: Object, createInitialState: Function, isStateEqual: Function): any[];
/**
 * Computes the controlled state using a the previous state, props,
 * two reducers, one from downshift and an optional one from the user.
 * Also calls the onChange handlers for state values that have changed.
 *
 * @param {Function} reducer Reducer function from downshift.
 * @param {Object} props The hook props, also passed to createInitialState.
 * @param {Function} createInitialState Function that returns the initial state.
 * @param {Function} isStateEqual Function that checks if a previous state is equal to the next.
 * @returns {Array} An array with the state and an action dispatcher.
 */
export function useEnhancedReducer(reducer: Function, props: Object, createInitialState: Function, isStateEqual: Function): any[];
export function useLatestRef(val: any): React.MutableRefObject<any>;
export function capitalizeString(string: any): string;
export function isAcceptedCharacterKey(key: any): boolean;
export function getItemAndIndex(itemProp: any, indexProp: any, items: any, errorMessage: any): any[];
export const useElementIds: (({ id, labelId, menuId, getItemId, toggleButtonId, inputId, }: {
    id: any;
    labelId: any;
    menuId: any;
    getItemId: any;
    toggleButtonId: any;
    inputId: any;
}) => {
    labelId: any;
    menuId: any;
    getItemId: any;
    toggleButtonId: any;
    inputId: any;
}) | (({ id, labelId, menuId, getItemId, toggleButtonId, inputId, }: {
    id?: string | undefined;
    labelId: any;
    menuId: any;
    getItemId: any;
    toggleButtonId: any;
    inputId: any;
}) => {
    labelId: any;
    menuId: any;
    getItemId: any;
    toggleButtonId: any;
    inputId: any;
});
/**
 * Handles selection on Enter / Alt + ArrowUp. Closes the menu and resets the highlighted index, unless there is a highlighted.
 * In that case, selects the item and resets to defaults for open state and highlighted idex.
 * @param {Object} props The useCombobox props.
 * @param {number} highlightedIndex The index from the state.
 * @param {boolean} inputValue Also return the input value for state.
 * @returns The changes for the state.
 */
export function getChangesOnSelection(props: Object, highlightedIndex: number, inputValue?: boolean): any;
/**
 * Check if a state is equal for dropdowns, by comparing isOpen, inputValue, highlightedIndex and selected item.
 * Used by useSelect and useCombobox.
 *
 * @param {Object} prevState
 * @param {Object} newState
 * @returns {boolean} Wheather the states are deeply equal.
 */
export function isDropdownsStateEqual(prevState: Object, newState: Object): boolean;
export namespace commonDropdownPropTypes {
    export const getA11yStatusMessage: PropTypes.Requireable<(...args: any[]) => any>;
    export const highlightedIndex: PropTypes.Requireable<number>;
    export const defaultHighlightedIndex: PropTypes.Requireable<number>;
    export const initialHighlightedIndex: PropTypes.Requireable<number>;
    export const isOpen: PropTypes.Requireable<boolean>;
    export const defaultIsOpen: PropTypes.Requireable<boolean>;
    export const initialIsOpen: PropTypes.Requireable<boolean>;
    export const selectedItem: PropTypes.Requireable<any>;
    export const initialSelectedItem: PropTypes.Requireable<any>;
    export const defaultSelectedItem: PropTypes.Requireable<any>;
    export const id: PropTypes.Requireable<string>;
    export const labelId: PropTypes.Requireable<string>;
    export const menuId: PropTypes.Requireable<string>;
    export const getItemId: PropTypes.Requireable<(...args: any[]) => any>;
    export const toggleButtonId: PropTypes.Requireable<string>;
    export const onSelectedItemChange: PropTypes.Requireable<(...args: any[]) => any>;
    export const onHighlightedIndexChange: PropTypes.Requireable<(...args: any[]) => any>;
    export const onStateChange: PropTypes.Requireable<(...args: any[]) => any>;
    export const onIsOpenChange: PropTypes.Requireable<(...args: any[]) => any>;
    const scrollIntoView_1: PropTypes.Requireable<(...args: any[]) => any>;
    export { scrollIntoView_1 as scrollIntoView };
    const environment_1: PropTypes.Requireable<PropTypes.InferProps<{
        addEventListener: PropTypes.Validator<(...args: any[]) => any>;
        removeEventListener: PropTypes.Validator<(...args: any[]) => any>;
        document: PropTypes.Validator<NonNullable<PropTypes.InferProps<{
            createElement: PropTypes.Validator<(...args: any[]) => any>;
            getElementById: PropTypes.Validator<(...args: any[]) => any>;
            activeElement: PropTypes.Validator<any>;
            body: PropTypes.Validator<any>;
        }>>>;
        Node: PropTypes.Validator<(...args: any[]) => any>;
    }>>;
    export { environment_1 as environment };
    export const itemToString: PropTypes.Requireable<(...args: any[]) => any>;
    export const itemToKey: PropTypes.Requireable<(...args: any[]) => any>;
    const stateReducer_1: PropTypes.Requireable<(...args: any[]) => any>;
    export { stateReducer_1 as stateReducer };
}
export namespace commonPropTypes { }
/**
 * Tracks if it's the first render.
 */
export function useIsInitialMount(): boolean;
/**
 * Adds an a11y aria live status message if getA11yStatusMessage is passed.
 * @param {(options: Object) => string} getA11yStatusMessage The function that builds the status message.
 * @param {Object} options The options to be passed to getA11yStatusMessage if called.
 * @param {Array<unknown>} dependencyArray The dependency array that triggers the status message setter via useEffect.
 * @param {{document: Document}} environment The environment object containing the document.
 */
export function useA11yMessageStatus(getA11yStatusMessage: (options: Object) => string, options: Object, dependencyArray: Array<unknown>, environment?: {
    document: Document;
}): void;
/**
 * Returns the new highlightedIndex based on the defaultHighlightedIndex prop, if it's not disabled.
 *
 * @param {Object} props Props from useCombobox or useSelect.
 * @returns {number} The highlighted index.
 */
export function getDefaultHighlightedIndex(props: Object): number;
import { noop } from "../utils";
import React from "react";
/**
 * Default state reducer that returns the changes.
 *
 * @param {Object} s state.
 * @param {Object} a action with changes.
 * @returns {Object} changes.
 */
declare function stateReducer(s: Object, a: Object): Object;
import { scrollIntoView } from "../utils";
import PropTypes from "prop-types";
export {};
