/**
 * A {@link LaneOperator} that assigns lanes to minimize edge crossings.
 *
 * @packageDocumentation
 */
import { LaneOperator } from ".";
/**
 * A lane operator that assigns lanes to minimize edge crossings.
 *
 * Create with {@link opt}.
 *
 * @example
 * <img alt="grid greedy example" src="media://grid-opt.png" width="200">
 */
export interface OptOperator extends LaneOperator<unknown, unknown> {
    /**
     * Set whether to used compressed output
     *
     * If output is compressed then the number of crossings will be minimized
     * subject to the fewest number of lanes necessary. (default: false)
     */
    compressed(val: boolean): OptOperator;
    /** Get the current compressed setting */
    compressed(): boolean;
    /**
     * Set whether to also minimize distance between connected nodes
     *
     * This adds more variables and constraints so will take longer, but will
     * likely produce a better layout. (default: true)
     */
    dist(val: boolean): OptOperator;
    /** get whether the current layout minimized distance */
    dist(): boolean;
}
/**
 * Create a default {@link OptOperator}, bundled as {@link laneOpt}.
 */
export declare function opt(...args: never[]): OptOperator;
