import type { Patterns } from '@grafana/faro-core';
/**
 * Retrieves a list of URLs to be ignored by aggregating the ignore URLs from all transports.
 *
 * @returns {string[]} An array of URLs to be ignored.
 */
export declare function getIgnoreUrls(): Patterns;
/**
 * Checks if the given URL should be ignored based on a list of ignored URLs.
 *
 * @param url - The URL to check.
 * @returns `true` if the URL is in the list of ignored URLs, `false` otherwise.
 */
export declare function isUrlIgnored(url?: string): boolean;
/**
 * Extracts a URL string from the given resource.
 *
 * @param resource - The input resource which can be a string, a URL object, or an object with a `toString` method.
 * @returns The URL as a string if the resource is a valid URL-like object, or `undefined` if the resource is not valid.
 *
 */
export declare function getUrlFromResource(resource: any): string | undefined;
