import { faro, genShortID } from '@grafana/faro-core';
import { isUrlIgnored } from '../../utils/url';
import { RESOURCE_ENTRY } from './performanceConstants';
import { createFaroResourceTiming, getSpanContextFromServerTiming, includePerformanceEntry } from './performanceUtils';
const DEFAULT_TRACK_RESOURCES = { initiatorType: ['xmlhttprequest', 'fetch'] };
export function observeResourceTimings(faroNavigationId, pushEvent, observable) {
    const trackResources = faro.config.trackResources;
    const observer = new PerformanceObserver((observedEntries) => {
        const entries = observedEntries.getEntries();
        for (const resourceEntryRaw of entries) {
            if (isUrlIgnored(resourceEntryRaw.name)) {
                return;
            }
            const resourceEntryJson = resourceEntryRaw.toJSON();
            let spanContext = getSpanContextFromServerTiming(resourceEntryJson === null || resourceEntryJson === void 0 ? void 0 : resourceEntryJson.serverTiming);
            if ((trackResources == null && includePerformanceEntry(resourceEntryJson, DEFAULT_TRACK_RESOURCES)) ||
                trackResources) {
                const faroResourceEntry = Object.assign(Object.assign({}, createFaroResourceTiming(resourceEntryJson)), { faroNavigationId, faroResourceId: genShortID() });
                if (faro.config.trackUserActionsPreview) {
                    observable === null || observable === void 0 ? void 0 : observable.notify({
                        type: RESOURCE_ENTRY,
                    });
                }
                pushEvent('faro.performance.resource', faroResourceEntry, undefined, {
                    spanContext,
                    timestampOverwriteMs: performance.timeOrigin + resourceEntryJson.startTime,
                });
            }
        }
    });
    observer.observe({
        type: RESOURCE_ENTRY,
        buffered: true,
    });
}
//# sourceMappingURL=resource.js.map