var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { BaseInstrumentation, Observable, VERSION } from '@grafana/faro-core';
import { getNavigationTimings } from './navigation';
import { onDocumentReady, performanceObserverSupported } from './performanceUtils';
import { observeResourceTimings } from './resource';
export const performanceEntriesSubscription = new Observable();
export class PerformanceInstrumentation extends BaseInstrumentation {
    constructor() {
        super(...arguments);
        this.name = '@grafana/faro-web-sdk:instrumentation-performance';
        this.version = VERSION;
    }
    initialize() {
        if (!performanceObserverSupported()) {
            this.logDebug('performance observer not supported. Disable performance instrumentation.');
            return;
        }
        onDocumentReady(() => __awaiter(this, void 0, void 0, function* () {
            const pushEvent = this.api.pushEvent;
            const { faroNavigationId } = yield getNavigationTimings(pushEvent);
            if (faroNavigationId != null) {
                observeResourceTimings(faroNavigationId, pushEvent, performanceEntriesSubscription);
            }
        }));
    }
}
//# sourceMappingURL=instrumentation.js.map