import { getDetailsFromErrorArgs } from './getErrorDetails';
export function registerOnerror(api) {
    const oldOnerror = window.onerror;
    window.onerror = (...args) => {
        try {
            const { value, type, stackFrames } = getDetailsFromErrorArgs(args);
            const originalError = args[4];
            if (value) {
                const options = { type, stackFrames };
                if (originalError != null) {
                    options.originalError = originalError;
                }
                api.pushError(new Error(value), options);
            }
        }
        finally {
            oldOnerror === null || oldOnerror === void 0 ? void 0 : oldOnerror.apply(window, args);
        }
    };
}
//# sourceMappingURL=registerOnerror.js.map