import { BaseInstrumentation, stringifyObjectValues, VERSION } from '@grafana/faro-core';
export class CSPInstrumentation extends BaseInstrumentation {
    constructor() {
        super();
        this.name = '@grafana/faro-web-sdk:instrumentation-csp';
        this.version = VERSION;
    }
    initialize() {
        document.addEventListener('securitypolicyviolation', this.securitypolicyviolationHandler.bind(this));
    }
    destroy() {
        document.removeEventListener('securitypolicyviolation', this.securitypolicyviolationHandler);
    }
    securitypolicyviolationHandler(ev) {
        this.api.pushEvent('securitypolicyviolation', stringifyObjectValues(ev));
    }
}
//# sourceMappingURL=instrumentation.js.map