var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { createInternalLogger, defaultBatchingConfig, defaultGlobalObjectKey, defaultInternalLoggerLevel, defaultLogArgsSerializer, defaultUnpatchedConsole, isBoolean, isEmpty, isObject, } from '@grafana/faro-core';
import { defaultEventDomain } from '../consts';
import { parseStacktrace } from '../instrumentations';
import { defaultSessionTrackingConfig } from '../instrumentations/session';
import { userActionDataAttribute } from '../instrumentations/userActions/const';
import { browserMeta } from '../metas';
import { k6Meta } from '../metas/k6';
import { createPageMeta } from '../metas/page';
import { FetchTransport } from '../transports';
import { getWebInstrumentations } from './getWebInstrumentations';
export function makeCoreConfig(browserConfig) {
    var _a;
    const transports = [];
    const internalLogger = createInternalLogger(browserConfig.unpatchedConsole, browserConfig.internalLoggerLevel);
    if (browserConfig.transports) {
        if (browserConfig.url || browserConfig.apiKey) {
            internalLogger.error('if "transports" is defined, "url" and "apiKey" should not be defined');
        }
        transports.push(...browserConfig.transports);
    }
    else if (browserConfig.url) {
        transports.push(new FetchTransport({
            url: browserConfig.url,
            apiKey: browserConfig.apiKey,
        }));
    }
    else {
        internalLogger.error('either "url" or "transports" must be defined');
    }
    const { 
    // properties with default values
    dedupe = true, eventDomain = defaultEventDomain, globalObjectKey = defaultGlobalObjectKey, instrumentations = getWebInstrumentations(), internalLoggerLevel = defaultInternalLoggerLevel, isolate = false, logArgsSerializer = defaultLogArgsSerializer, metas = createDefaultMetas(browserConfig), paused = false, preventGlobalExposure = false, unpatchedConsole = defaultUnpatchedConsole, trackUserActionsPreview = false, trackUserActionsDataAttributeName = userActionDataAttribute, url: browserConfigUrl } = browserConfig, 
    // Properties without default values or which aren't used to create derived config
    restProperties = __rest(browserConfig, ["dedupe", "eventDomain", "globalObjectKey", "instrumentations", "internalLoggerLevel", "isolate", "logArgsSerializer", "metas", "paused", "preventGlobalExposure", "unpatchedConsole", "trackUserActionsPreview", "trackUserActionsDataAttributeName", "url"]);
    return Object.assign(Object.assign({}, restProperties), { batching: Object.assign(Object.assign({}, defaultBatchingConfig), browserConfig.batching), dedupe: dedupe, globalObjectKey, instrumentations: getFilteredInstrumentations(instrumentations, browserConfig), internalLoggerLevel,
        isolate,
        logArgsSerializer,
        metas,
        parseStacktrace,
        paused,
        preventGlobalExposure,
        transports,
        unpatchedConsole,
        eventDomain, ignoreUrls: [
            ...((_a = browserConfig.ignoreUrls) !== null && _a !== void 0 ? _a : []),
            // ignore configured cloud collector url by default
            ...(browserConfigUrl ? [browserConfigUrl] : []),
            // Try our best to exclude collector URLs form other Faro instances. By default these are URLs ending with /collect or /collect/ followed by alphanumeric characters.
            /\/collect(?:\/[\w]*)?$/,
        ], sessionTracking: Object.assign(Object.assign(Object.assign({}, defaultSessionTrackingConfig), browserConfig.sessionTracking), crateSessionMeta({
            trackGeolocation: browserConfig.trackGeolocation,
            sessionTracking: browserConfig.sessionTracking,
        })), trackUserActionsPreview,
        trackUserActionsDataAttributeName });
}
function getFilteredInstrumentations(instrumentations, { trackUserActionsPreview }) {
    return instrumentations.filter((instr) => {
        if (instr.name === '@grafana/faro-web-sdk:instrumentation-user-action' && !trackUserActionsPreview) {
            return false;
        }
        return true;
    });
}
function createDefaultMetas(browserConfig) {
    var _a, _b;
    const { page, generatePageId } = (_a = browserConfig === null || browserConfig === void 0 ? void 0 : browserConfig.pageTracking) !== null && _a !== void 0 ? _a : {};
    const initialMetas = [
        browserMeta,
        createPageMeta({ generatePageId, initialPageMeta: page }),
        ...((_b = browserConfig.metas) !== null && _b !== void 0 ? _b : []),
    ];
    const isK6BrowserSession = isObject(window.k6);
    if (isK6BrowserSession) {
        return [...initialMetas, k6Meta];
    }
    return initialMetas;
}
function crateSessionMeta({ trackGeolocation, sessionTracking, }) {
    var _a;
    const overrides = {};
    if (isBoolean(trackGeolocation)) {
        overrides.geoLocationTrackingEnabled = trackGeolocation;
    }
    if (isEmpty(overrides)) {
        return {};
    }
    return {
        session: Object.assign(Object.assign({}, ((_a = sessionTracking === null || sessionTracking === void 0 ? void 0 : sessionTracking.session) !== null && _a !== void 0 ? _a : {})), { overrides }),
    };
}
//# sourceMappingURL=makeCoreConfig.js.map