import { ConsoleInstrumentation, CSPInstrumentation, ErrorsInstrumentation, PerformanceInstrumentation, SessionInstrumentation, UserActionInstrumentation, ViewInstrumentation, WebVitalsInstrumentation, } from '../instrumentations';
export function getWebInstrumentations(options = {}) {
    const instrumentations = [
        new UserActionInstrumentation(),
        new ErrorsInstrumentation(),
        new WebVitalsInstrumentation(),
        new SessionInstrumentation(),
        new ViewInstrumentation(),
    ];
    if (options.enablePerformanceInstrumentation !== false) {
        // unshift to ensure that initialization starts before the other instrumentations
        instrumentations.unshift(new PerformanceInstrumentation());
    }
    if (options.enableContentSecurityPolicyInstrumentation !== false) {
        instrumentations.push(new CSPInstrumentation());
    }
    if (options.captureConsole !== false) {
        instrumentations.push(new ConsoleInstrumentation({
            disabledLevels: options.captureConsoleDisabledLevels,
        }));
    }
    return instrumentations;
}
//# sourceMappingURL=getWebInstrumentations.js.map