"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViewInstrumentation = void 0;
var faro_core_1 = require("@grafana/faro-core");
// all this does is send VIEW_CHANGED event
var ViewInstrumentation = /** @class */ (function (_super) {
    __extends(ViewInstrumentation, _super);
    function ViewInstrumentation() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = '@grafana/faro-web-sdk:instrumentation-view';
        _this.version = faro_core_1.VERSION;
        return _this;
    }
    ViewInstrumentation.prototype.sendViewChangedEvent = function (meta) {
        var _a, _b, _c, _d;
        var view = meta.view;
        if (view && view.name !== ((_a = this.notifiedView) === null || _a === void 0 ? void 0 : _a.name)) {
            this.api.pushEvent(faro_core_1.EVENT_VIEW_CHANGED, {
                fromView: (_c = (_b = this.notifiedView) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : faro_core_1.unknownString,
                toView: (_d = view.name) !== null && _d !== void 0 ? _d : faro_core_1.unknownString,
            }, undefined, { skipDedupe: true });
            this.notifiedView = view;
        }
    };
    ViewInstrumentation.prototype.initialize = function () {
        this.metas.addListener(this.sendViewChangedEvent.bind(this));
    };
    return ViewInstrumentation;
}(faro_core_1.BaseInstrumentation));
exports.ViewInstrumentation = ViewInstrumentation;
//# sourceMappingURL=instrumentation.js.map