"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.monitorHttpRequests = monitorHttpRequests;
var faro_core_1 = require("@grafana/faro-core");
var url_1 = require("../../utils/url");
var const_1 = require("./const");
var apiTypeFetch = 'fetch';
var apiTypeXhr = 'xhr';
/**
 * Monitors if any http requests are in progress.
 */
function monitorHttpRequests() {
    var observable = new faro_core_1.Observable();
    function emitStartMessage(requestProps) {
        observable.notify({
            type: const_1.MESSAGE_TYPE_HTTP_REQUEST_START,
            request: requestProps,
        });
    }
    function emitEndMessage(requestProps) {
        observable.notify({
            type: const_1.MESSAGE_TYPE_HTTP_REQUEST_END,
            request: requestProps,
        });
    }
    monitorFetch({
        onRequestStart: emitStartMessage,
        onRequestEnd: emitEndMessage,
    });
    monitorXhr({
        onRequestStart: emitStartMessage,
        onRequestEnd: emitEndMessage,
    });
    return observable;
}
function monitorXhr(_a) {
    var onRequestStart = _a.onRequestStart, onRequestEnd = _a.onRequestEnd;
    var originalOpen = XMLHttpRequest.prototype.open;
    XMLHttpRequest.prototype.open = function () {
        var url = arguments[1];
        var isIgnoredUrl = (0, url_1.isUrlIgnored)(url);
        var method = arguments[0];
        var requestId = (0, faro_core_1.genShortID)();
        // request has started to load data.
        this.addEventListener('loadstart', function () {
            if (!isIgnoredUrl) {
                onRequestStart({ url: url, method: method, requestId: requestId, apiType: apiTypeXhr });
            }
        });
        // transaction completes successfully.
        this.addEventListener('load', function () {
            if (!isIgnoredUrl) {
                onRequestEnd({ url: url, method: method, requestId: requestId, apiType: apiTypeXhr });
            }
        });
        this.addEventListener('error', function () {
            if (!isIgnoredUrl) {
                onRequestEnd({ url: url, method: method, requestId: requestId, apiType: apiTypeXhr });
            }
        });
        this.addEventListener('abort', function () {
            if (!isIgnoredUrl) {
                onRequestEnd({ url: url, method: method, requestId: requestId, apiType: apiTypeXhr });
            }
        });
        originalOpen.apply(this, arguments);
    };
}
function monitorFetch(_a) {
    var onRequestEnd = _a.onRequestEnd, onRequestStart = _a.onRequestStart;
    var originalFetch = window.fetch;
    window.fetch = function () {
        var _a, _b;
        var url = (_a = (0, url_1.getUrlFromResource)(arguments[0])) !== null && _a !== void 0 ? _a : '';
        var isIgnoredUrl = (0, url_1.isUrlIgnored)(url);
        var method = ((_b = arguments[1]) !== null && _b !== void 0 ? _b : {}).method;
        var requestId = (0, faro_core_1.genShortID)();
        if (!isIgnoredUrl) {
            onRequestStart({ url: url, method: method, requestId: requestId, apiType: apiTypeFetch });
        }
        return originalFetch
            .apply(this, arguments)
            .then(function (response) {
            if (!isIgnoredUrl) {
                onRequestEnd({ url: url, method: method, requestId: requestId, apiType: apiTypeFetch });
            }
            return response;
        })
            .catch(function (error) {
            if (!isIgnoredUrl) {
                onRequestEnd({ url: url, method: method, requestId: requestId, apiType: apiTypeFetch });
            }
            throw error;
        });
    };
}
//# sourceMappingURL=httpRequestMonitor.js.map