"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildStackFrame = buildStackFrame;
var const_1 = require("./const");
function buildStackFrame(filename, func, lineno, colno) {
    var stackFrame = {
        filename: filename || document.location.href,
        function: func || const_1.unknownSymbolString,
    };
    if (lineno !== undefined) {
        stackFrame.lineno = lineno;
    }
    if (colno !== undefined) {
        stackFrame.colno = colno;
    }
    return stackFrame;
}
//# sourceMappingURL=buildStackFrame.js.map