"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerOnerror = registerOnerror;
var getErrorDetails_1 = require("./getErrorDetails");
function registerOnerror(api) {
    var oldOnerror = window.onerror;
    window.onerror = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        try {
            var _a = (0, getErrorDetails_1.getDetailsFromErrorArgs)(args), value = _a.value, type = _a.type, stackFrames = _a.stackFrames;
            var originalError = args[4];
            if (value) {
                var options = { type: type, stackFrames: stackFrames };
                if (originalError != null) {
                    options.originalError = originalError;
                }
                api.pushError(new Error(value), options);
            }
        }
        finally {
            oldOnerror === null || oldOnerror === void 0 ? void 0 : oldOnerror.apply(window, args);
        }
    };
}
//# sourceMappingURL=registerOnerror.js.map