"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getErrorDetails = getErrorDetails;
exports.getDetailsFromErrorArgs = getDetailsFromErrorArgs;
exports.getDetailsFromConsoleErrorArgs = getDetailsFromConsoleErrorArgs;
var faro_core_1 = require("@grafana/faro-core");
var const_1 = require("./const");
var getValueAndTypeFromMessage_1 = require("./getValueAndTypeFromMessage");
var stackFrames_1 = require("./stackFrames");
function getErrorDetails(evt) {
    var value;
    var type;
    var stackFrames = [];
    var isDomErrorRes;
    var isEventRes;
    if ((0, faro_core_1.isErrorEvent)(evt) && evt.error) {
        value = evt.error.message;
        type = evt.error.name;
        stackFrames = (0, stackFrames_1.getStackFramesFromError)(evt.error);
    }
    else if ((isDomErrorRes = (0, faro_core_1.isDomError)(evt)) || (0, faro_core_1.isDomException)(evt)) {
        var name_1 = evt.name, message = evt.message;
        type = name_1 !== null && name_1 !== void 0 ? name_1 : (isDomErrorRes ? const_1.domErrorType : const_1.domExceptionType);
        value = message ? "".concat(type, ": ").concat(message) : type;
    }
    else if ((0, faro_core_1.isError)(evt)) {
        value = evt.message;
        stackFrames = (0, stackFrames_1.getStackFramesFromError)(evt);
    }
    else if ((0, faro_core_1.isObject)(evt) || (isEventRes = (0, faro_core_1.isEvent)(evt))) {
        type = isEventRes ? evt.constructor.name : undefined;
        value = "".concat(const_1.objectEventValue, " ").concat(Object.keys(evt));
    }
    return [value, type, stackFrames];
}
function getDetailsFromErrorArgs(args) {
    var _a, _b;
    var evt = args[0], source = args[1], lineno = args[2], colno = args[3], error = args[4];
    var value;
    var type;
    var stackFrames = [];
    var eventIsString = (0, faro_core_1.isString)(evt);
    var initialStackFrame = (0, stackFrames_1.buildStackFrame)(source, const_1.unknownSymbolString, lineno, colno);
    if (error || !eventIsString) {
        _a = getErrorDetails((error !== null && error !== void 0 ? error : evt)), value = _a[0], type = _a[1], stackFrames = _a[2];
        if (stackFrames.length === 0) {
            stackFrames = [initialStackFrame];
        }
    }
    else if (eventIsString) {
        _b = (0, getValueAndTypeFromMessage_1.getValueAndTypeFromMessage)(evt), value = _b[0], type = _b[1];
        stackFrames = [initialStackFrame];
    }
    return { value: value, type: type, stackFrames: stackFrames };
}
function getDetailsFromConsoleErrorArgs(args, serializer) {
    if ((0, faro_core_1.isError)(args[0])) {
        return getDetailsFromErrorArgs(args);
    }
    else {
        return { value: serializer(args) };
    }
}
//# sourceMappingURL=getErrorDetails.js.map