"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var initialize_1 = require("../initialize");
var testUtils_1 = require("../testUtils");
var utils_1 = require("../utils");
var version_1 = require("../version");
var base_1 = require("./base");
var const_1 = require("./const");
var MockSingleTransport = /** @class */ (function (_super) {
    __extends(MockSingleTransport, _super);
    function MockSingleTransport() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = '@grafana/transport-mock';
        _this.version = version_1.VERSION;
        _this.sentItems = [];
        return _this;
    }
    MockSingleTransport.prototype.send = function (item) {
        this.sentItems.push(item);
    };
    return MockSingleTransport;
}(base_1.BaseTransport));
var sendSingleMock = jest.spyOn(MockSingleTransport.prototype, 'send');
var MockTransport = /** @class */ (function (_super) {
    __extends(MockTransport, _super);
    function MockTransport() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = '@grafana/transport-single-mock';
        _this.version = version_1.VERSION;
        _this.sentItems = [];
        return _this;
    }
    MockTransport.prototype.send = function (items) {
        var _a;
        (_a = this.sentItems).push.apply(_a, items);
    };
    MockTransport.prototype.isBatched = function () {
        return true;
    };
    return MockTransport;
}(base_1.BaseTransport));
var sendMock = jest.spyOn(MockTransport.prototype, 'send');
describe('transports', function () {
    describe('config.beforeSend', function () {
        it('will not send events that are rejected by beforeSend hook', function () {
            var _a;
            var transport = new MockTransport();
            var hookedItems = [];
            var transports = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
                transports: [transport],
                beforeSend: function (item) {
                    hookedItems.push(item);
                    if (item.type === const_1.TransportItemType.EXCEPTION && item.payload.type === 'TypeError') {
                        return null;
                    }
                    return item;
                },
            })).transports;
            transports.execute(makeExceptionTransportItem('Error', 'ResizeObserver loop limit exceeded'));
            transports.execute(makeExceptionTransportItem('TypeError', '_.viz is undefined'));
            expect(transport.sentItems).toHaveLength(1);
            expect(hookedItems).toHaveLength(2);
            expect(((_a = transport.sentItems[0]) === null || _a === void 0 ? void 0 : _a.payload).type).toEqual('Error');
        });
        it('events can be modified by beforeSend hook', function () {
            var _a;
            var transport = new MockTransport();
            var transports = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
                transports: [transport],
                beforeSend: function (item) {
                    if (item.type === const_1.TransportItemType.EXCEPTION) {
                        return __assign(__assign({}, item), { payload: __assign(__assign({}, item.payload), { type: 'NewType' }) });
                    }
                    return item;
                },
            })).transports;
            transports.execute(makeExceptionTransportItem('Error', 'ResizeObserver loop limit exceeded'));
            expect(transport.sentItems).toHaveLength(1);
            expect(((_a = transport.sentItems[0]) === null || _a === void 0 ? void 0 : _a.payload).type).toEqual('NewType');
        });
        it('Only call beforeSentHooks once in batched mode.', function () {
            var transport = new MockTransport();
            var mockBeforeSend = jest.fn(function (item) { return item; });
            var transports = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
                transports: [transport],
                beforeSend: mockBeforeSend,
                batching: {
                    enabled: true,
                    sendTimeout: 1,
                    itemLimit: 1,
                },
            })).transports;
            transports.execute(makeExceptionTransportItem('Error', 'ResizeObserver loop limit exceeded'));
            expect(mockBeforeSend).toHaveBeenCalledTimes(1);
        });
        it('Call beforeSentHooks two times if in batched mode but with an existing transport which is not batched', function () {
            var transport = new MockTransport();
            var nonBachedTransport = new MockTransport();
            nonBachedTransport.isBatched = function () { return false; };
            nonBachedTransport.name = 'non-batched-transport';
            var mockBeforeSend = jest.fn(function (item) { return item; });
            var transports = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
                transports: [transport, nonBachedTransport],
                beforeSend: mockBeforeSend,
                batching: {
                    enabled: true,
                    sendTimeout: 1,
                    itemLimit: 1,
                },
            })).transports;
            transports.execute(makeExceptionTransportItem('Error', 'ResizeObserver loop limit exceeded'));
            expect(mockBeforeSend).toHaveBeenCalledTimes(2);
        });
        it('Sanitizes data before sending', function () {
            var transport = new MockTransport();
            var api = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
                isolate: true,
                instrumentations: [],
                transports: [transport],
                batching: {
                    enabled: true,
                    itemLimit: 1,
                },
                preserveOriginalError: true,
            })).api;
            api.pushError(new Error('Kaboom1'));
            api.pushError(new Error('Kaboom2'));
            expect(transport.sentItems).toHaveLength(2);
            expect(transport.sentItems[0]).not.toHaveProperty('originalError');
            expect(transport.sentItems[1]).not.toHaveProperty('originalError');
        });
        it('Original error is available in beforeSend function', function () {
            var mockBeforeSend = jest.fn();
            var transport = new MockTransport();
            var api = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
                isolate: true,
                instrumentations: [],
                transports: [transport],
                batching: {
                    enabled: true,
                    itemLimit: 1,
                },
                preserveOriginalError: true,
                beforeSend: mockBeforeSend,
            })).api;
            var myError = new Error('Kaboom');
            api.pushError(myError, { originalError: myError });
            expect(mockBeforeSend).toHaveBeenCalledTimes(1);
            expect(mockBeforeSend.mock.calls[0][0]).toHaveProperty('payload.originalError', myError);
        });
    });
    describe('multiple transports of the same type', function () {
        var transport1 = new MockTransport();
        var transport2 = new MockTransport();
        var transports = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
            isolate: true,
            instrumentations: [],
            transports: [transport1, transport2],
        })).transports;
        it('will all be added and receive events', function () {
            transports.execute(makeExceptionTransportItem('Error', 'ResizeObserver loop limit exceeded'));
            expect(transport1.sentItems).toHaveLength(1);
            expect(transport2.sentItems).toHaveLength(1);
        });
        it('one of them can be removed by instance', function () {
            transports.remove(transport1);
            transports.execute(makeExceptionTransportItem('Error', 'Kaboom'));
            expect(transport1.sentItems).toHaveLength(1);
            expect(transport2.sentItems).toHaveLength(2);
        });
    });
    describe('test batched transports and single item ones', function () {
        beforeAll(function () {
            jest.useFakeTimers();
        });
        beforeEach(function () {
            jest.clearAllMocks();
        });
        it('single item transports with batching enabled', function () {
            var transport = new MockSingleTransport();
            var transports = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
                isolate: true,
                instrumentations: [],
                transports: [transport],
                batching: {
                    enabled: true,
                    sendTimeout: 1,
                },
            })).transports;
            var item1 = makeExceptionTransportItem('Error', 'Kaboom');
            var item2 = makeExceptionTransportItem('Error', 'Kaboom');
            transports.execute(item1);
            transports.execute(item2);
            jest.advanceTimersByTime(1);
            expect(sendSingleMock).toHaveBeenCalledTimes(2);
            expect(sendSingleMock.mock.calls).toEqual([[item1], [item2]]);
        });
        it('multiple item transports', function () {
            var transport = new MockTransport();
            var transports = (0, initialize_1.initializeFaro)((0, testUtils_1.mockConfig)({
                isolate: true,
                instrumentations: [],
                transports: [transport],
                batching: {
                    enabled: true,
                    sendTimeout: 1,
                },
            })).transports;
            var item1 = makeExceptionTransportItem('Error', 'Kaboom');
            var item2 = makeExceptionTransportItem('Error', 'Kaboom');
            transports.execute(item1);
            transports.execute(item2);
            jest.advanceTimersByTime(1);
            expect(sendMock).toHaveBeenCalledWith([item1, item2]);
        });
    });
});
function makeExceptionTransportItem(type, value) {
    return {
        type: const_1.TransportItemType.EXCEPTION,
        payload: {
            type: type,
            value: value,
            timestamp: (0, utils_1.getCurrentTimestamp)(),
            stacktrace: {
                frames: [],
            },
        },
        meta: {},
    };
}
//# sourceMappingURL=transports.test.js.map