"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeLogsAPI = initializeLogsAPI;
var transports_1 = require("../../transports");
var utils_1 = require("../../utils");
var date_1 = require("../../utils/date");
var const_1 = require("../const");
var const_2 = require("./const");
function initializeLogsAPI(_a) {
    var _b;
    var internalLogger = _a.internalLogger, config = _a.config, metas = _a.metas, transports = _a.transports, tracesApi = _a.tracesApi, actionBuffer = _a.actionBuffer, getMessage = _a.getMessage;
    internalLogger.debug('Initializing logs API');
    var lastPayload = null;
    var logArgsSerializer = (_b = config.logArgsSerializer) !== null && _b !== void 0 ? _b : const_2.defaultLogArgsSerializer;
    var pushLog = function (args, _a) {
        var _b = _a === void 0 ? {} : _a, context = _b.context, level = _b.level, skipDedupe = _b.skipDedupe, spanContext = _b.spanContext, timestampOverwriteMs = _b.timestampOverwriteMs;
        try {
            var ctx = (0, utils_1.stringifyObjectValues)(context);
            var item = {
                type: transports_1.TransportItemType.LOG,
                payload: {
                    message: logArgsSerializer(args),
                    level: level !== null && level !== void 0 ? level : utils_1.defaultLogLevel,
                    context: (0, utils_1.isEmpty)(ctx) ? undefined : ctx,
                    timestamp: timestampOverwriteMs ? (0, date_1.timestampToIsoString)(timestampOverwriteMs) : (0, utils_1.getCurrentTimestamp)(),
                    trace: spanContext
                        ? {
                            trace_id: spanContext.traceId,
                            span_id: spanContext.spanId,
                        }
                        : tracesApi.getTraceContext(),
                },
                meta: metas.value,
            };
            var testingPayload = {
                message: item.payload.message,
                level: item.payload.level,
                context: item.payload.context,
            };
            if (!skipDedupe && config.dedupe && !(0, utils_1.isNull)(lastPayload) && (0, utils_1.deepEqual)(testingPayload, lastPayload)) {
                internalLogger.debug('Skipping log push because it is the same as the last one\n', item.payload);
                return;
            }
            lastPayload = testingPayload;
            internalLogger.debug('Pushing log\n', item);
            var msg = getMessage();
            if (msg && msg.type === const_1.USER_ACTION_START) {
                actionBuffer.addItem(item);
            }
            else {
                transports.execute(item);
            }
        }
        catch (err) {
            internalLogger.error('Error pushing log\n', err);
        }
    };
    return {
        pushLog: pushLog,
    };
}
//# sourceMappingURL=initialize.js.map