"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemBuffer = void 0;
var is_1 = require("../utils/is");
var ItemBuffer = /** @class */ (function () {
    function ItemBuffer() {
        this.buffer = [];
    }
    ItemBuffer.prototype.addItem = function (item) {
        this.buffer.push(item);
    };
    ItemBuffer.prototype.flushBuffer = function (cb) {
        if ((0, is_1.isFunction)(cb)) {
            for (var _i = 0, _a = this.buffer; _i < _a.length; _i++) {
                var item = _a[_i];
                cb(item);
            }
        }
        this.buffer.length = 0;
    };
    ItemBuffer.prototype.size = function () {
        return this.buffer.length;
    };
    return ItemBuffer;
}());
exports.ItemBuffer = ItemBuffer;
//# sourceMappingURL=ItemBuffer.js.map