"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createInternalLogger = createInternalLogger;
var unpatchedConsole_1 = require("../unpatchedConsole");
var utils_1 = require("../utils");
var const_1 = require("./const");
function createInternalLogger(unpatchedConsole, internalLoggerLevel) {
    if (unpatchedConsole === void 0) { unpatchedConsole = unpatchedConsole_1.defaultUnpatchedConsole; }
    if (internalLoggerLevel === void 0) { internalLoggerLevel = const_1.defaultInternalLoggerLevel; }
    var internalLogger = const_1.defaultInternalLogger;
    if (internalLoggerLevel > const_1.InternalLoggerLevel.OFF) {
        internalLogger.error =
            internalLoggerLevel >= const_1.InternalLoggerLevel.ERROR
                ? function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    unpatchedConsole.error.apply(unpatchedConsole, __spreadArray(["".concat(internalLogger.prefix, "\n")], args, false));
                }
                : utils_1.noop;
        internalLogger.warn =
            internalLoggerLevel >= const_1.InternalLoggerLevel.WARN
                ? function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    unpatchedConsole.warn.apply(unpatchedConsole, __spreadArray(["".concat(internalLogger.prefix, "\n")], args, false));
                }
                : utils_1.noop;
        internalLogger.info =
            internalLoggerLevel >= const_1.InternalLoggerLevel.INFO
                ? function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    unpatchedConsole.info.apply(unpatchedConsole, __spreadArray(["".concat(internalLogger.prefix, "\n")], args, false));
                }
                : utils_1.noop;
        internalLogger.debug =
            internalLoggerLevel >= const_1.InternalLoggerLevel.VERBOSE
                ? function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    unpatchedConsole.debug.apply(unpatchedConsole, __spreadArray(["".concat(internalLogger.prefix, "\n")], args, false));
                }
                : utils_1.noop;
    }
    return internalLogger;
}
//# sourceMappingURL=createInternalLogger.js.map