"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeFaro = initializeFaro;
var api_1 = require("./api");
var instrumentations_1 = require("./instrumentations");
var internalLogger_1 = require("./internalLogger");
var metas_1 = require("./metas");
var sdk_1 = require("./sdk");
var transports_1 = require("./transports");
var unpatchedConsole_1 = require("./unpatchedConsole");
function initializeFaro(config) {
    var unpatchedConsole = (0, unpatchedConsole_1.initializeUnpatchedConsole)(config);
    var internalLogger = (0, internalLogger_1.initializeInternalLogger)(unpatchedConsole, config);
    if ((0, sdk_1.isInternalFaroOnGlobalObject)() && !config.isolate) {
        internalLogger.error('Faro is already registered. Either add instrumentations, transports etc. to the global faro instance or use the "isolate" property');
        return undefined;
    }
    internalLogger.debug('Initializing');
    // Initializing the APIs
    var metas = (0, metas_1.initializeMetas)(unpatchedConsole, internalLogger, config);
    var transports = (0, transports_1.initializeTransports)(unpatchedConsole, internalLogger, config, metas);
    var api = (0, api_1.initializeAPI)(unpatchedConsole, internalLogger, config, metas, transports);
    var instrumentations = (0, instrumentations_1.initializeInstrumentations)(unpatchedConsole, internalLogger, config, metas, transports, api);
    var faro = (0, sdk_1.registerFaro)(unpatchedConsole, internalLogger, config, metas, transports, api, instrumentations);
    // make sure Faro is initialized before registering default metas, instrumentations, transports etc.
    (0, metas_1.registerInitialMetas)(faro);
    (0, transports_1.registerInitialTransports)(faro);
    (0, instrumentations_1.registerInitialInstrumentations)(faro);
    return faro;
}
//# sourceMappingURL=initialize.js.map