// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/studio.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The protocols supported by Studio agent.
type StudioAgentProtocol int32

const (
	StudioAgentProtocol_STUDIO_AGENT_PROTOCOL_UNSPECIFIED StudioAgentProtocol = 0
	StudioAgentProtocol_STUDIO_AGENT_PROTOCOL_GRPC        StudioAgentProtocol = 1
	StudioAgentProtocol_STUDIO_AGENT_PROTOCOL_CONNECT     StudioAgentProtocol = 2
)

// Enum value maps for StudioAgentProtocol.
var (
	StudioAgentProtocol_name = map[int32]string{
		0: "STUDIO_AGENT_PROTOCOL_UNSPECIFIED",
		1: "STUDIO_AGENT_PROTOCOL_GRPC",
		2: "STUDIO_AGENT_PROTOCOL_CONNECT",
	}
	StudioAgentProtocol_value = map[string]int32{
		"STUDIO_AGENT_PROTOCOL_UNSPECIFIED": 0,
		"STUDIO_AGENT_PROTOCOL_GRPC":        1,
		"STUDIO_AGENT_PROTOCOL_CONNECT":     2,
	}
)

func (x StudioAgentProtocol) Enum() *StudioAgentProtocol {
	p := new(StudioAgentProtocol)
	*p = x
	return p
}

func (x StudioAgentProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StudioAgentProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_studio_proto_enumTypes[0].Descriptor()
}

func (StudioAgentProtocol) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_studio_proto_enumTypes[0]
}

func (x StudioAgentProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// StudioAgentPreset is the information about an agent preset in the Studio.
type StudioAgentPreset struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Url       string                 `protobuf:"bytes,1,opt,name=url,proto3"`
	xxx_hidden_Alias     string                 `protobuf:"bytes,2,opt,name=alias,proto3"`
	xxx_hidden_Protocol  StudioAgentProtocol    `protobuf:"varint,3,opt,name=protocol,proto3,enum=buf.alpha.registry.v1alpha1.StudioAgentProtocol"`
	xxx_hidden_TargetUrl string                 `protobuf:"bytes,4,opt,name=target_url,json=targetUrl,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *StudioAgentPreset) Reset() {
	*x = StudioAgentPreset{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StudioAgentPreset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudioAgentPreset) ProtoMessage() {}

func (x *StudioAgentPreset) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *StudioAgentPreset) GetUrl() string {
	if x != nil {
		return x.xxx_hidden_Url
	}
	return ""
}

func (x *StudioAgentPreset) GetAlias() string {
	if x != nil {
		return x.xxx_hidden_Alias
	}
	return ""
}

func (x *StudioAgentPreset) GetProtocol() StudioAgentProtocol {
	if x != nil {
		return x.xxx_hidden_Protocol
	}
	return StudioAgentProtocol_STUDIO_AGENT_PROTOCOL_UNSPECIFIED
}

func (x *StudioAgentPreset) GetTargetUrl() string {
	if x != nil {
		return x.xxx_hidden_TargetUrl
	}
	return ""
}

func (x *StudioAgentPreset) SetUrl(v string) {
	x.xxx_hidden_Url = v
}

func (x *StudioAgentPreset) SetAlias(v string) {
	x.xxx_hidden_Alias = v
}

func (x *StudioAgentPreset) SetProtocol(v StudioAgentProtocol) {
	x.xxx_hidden_Protocol = v
}

func (x *StudioAgentPreset) SetTargetUrl(v string) {
	x.xxx_hidden_TargetUrl = v
}

type StudioAgentPreset_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The agent URL in the Studio.
	Url string
	// The optional alias of the agent URL.
	Alias string
	// The protocol the agent should use to forward requests.
	Protocol StudioAgentProtocol
	// The URL of the target host.
	TargetUrl string
}

func (b0 StudioAgentPreset_builder) Build() *StudioAgentPreset {
	m0 := &StudioAgentPreset{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Url = b.Url
	x.xxx_hidden_Alias = b.Alias
	x.xxx_hidden_Protocol = b.Protocol
	x.xxx_hidden_TargetUrl = b.TargetUrl
	return m0
}

type ListStudioAgentPresetsRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListStudioAgentPresetsRequest) Reset() {
	*x = ListStudioAgentPresetsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListStudioAgentPresetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStudioAgentPresetsRequest) ProtoMessage() {}

func (x *ListStudioAgentPresetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type ListStudioAgentPresetsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 ListStudioAgentPresetsRequest_builder) Build() *ListStudioAgentPresetsRequest {
	m0 := &ListStudioAgentPresetsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type ListStudioAgentPresetsResponse struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Agents *[]*StudioAgentPreset  `protobuf:"bytes,1,rep,name=agents,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *ListStudioAgentPresetsResponse) Reset() {
	*x = ListStudioAgentPresetsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListStudioAgentPresetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStudioAgentPresetsResponse) ProtoMessage() {}

func (x *ListStudioAgentPresetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListStudioAgentPresetsResponse) GetAgents() []*StudioAgentPreset {
	if x != nil {
		if x.xxx_hidden_Agents != nil {
			return *x.xxx_hidden_Agents
		}
	}
	return nil
}

func (x *ListStudioAgentPresetsResponse) SetAgents(v []*StudioAgentPreset) {
	x.xxx_hidden_Agents = &v
}

type ListStudioAgentPresetsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Agents []*StudioAgentPreset
}

func (b0 ListStudioAgentPresetsResponse_builder) Build() *ListStudioAgentPresetsResponse {
	m0 := &ListStudioAgentPresetsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Agents = &b.Agents
	return m0
}

type SetStudioAgentPresetsRequest struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Agents *[]*StudioAgentPreset  `protobuf:"bytes,1,rep,name=agents,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *SetStudioAgentPresetsRequest) Reset() {
	*x = SetStudioAgentPresetsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetStudioAgentPresetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetStudioAgentPresetsRequest) ProtoMessage() {}

func (x *SetStudioAgentPresetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SetStudioAgentPresetsRequest) GetAgents() []*StudioAgentPreset {
	if x != nil {
		if x.xxx_hidden_Agents != nil {
			return *x.xxx_hidden_Agents
		}
	}
	return nil
}

func (x *SetStudioAgentPresetsRequest) SetAgents(v []*StudioAgentPreset) {
	x.xxx_hidden_Agents = &v
}

type SetStudioAgentPresetsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Agents []*StudioAgentPreset
}

func (b0 SetStudioAgentPresetsRequest_builder) Build() *SetStudioAgentPresetsRequest {
	m0 := &SetStudioAgentPresetsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Agents = &b.Agents
	return m0
}

type SetStudioAgentPresetsResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetStudioAgentPresetsResponse) Reset() {
	*x = SetStudioAgentPresetsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetStudioAgentPresetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetStudioAgentPresetsResponse) ProtoMessage() {}

func (x *SetStudioAgentPresetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type SetStudioAgentPresetsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 SetStudioAgentPresetsResponse_builder) Build() *SetStudioAgentPresetsResponse {
	m0 := &SetStudioAgentPresetsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

var File_buf_alpha_registry_v1alpha1_studio_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_studio_proto_rawDesc = "" +
	"\n" +
	"(buf/alpha/registry/v1alpha1/studio.proto\x12\x1bbuf.alpha.registry.v1alpha1\"\xa8\x01\n" +
	"\x11StudioAgentPreset\x12\x10\n" +
	"\x03url\x18\x01 \x01(\tR\x03url\x12\x14\n" +
	"\x05alias\x18\x02 \x01(\tR\x05alias\x12L\n" +
	"\bprotocol\x18\x03 \x01(\x0e20.buf.alpha.registry.v1alpha1.StudioAgentProtocolR\bprotocol\x12\x1d\n" +
	"\n" +
	"target_url\x18\x04 \x01(\tR\ttargetUrl\"\x1f\n" +
	"\x1dListStudioAgentPresetsRequest\"h\n" +
	"\x1eListStudioAgentPresetsResponse\x12F\n" +
	"\x06agents\x18\x01 \x03(\v2..buf.alpha.registry.v1alpha1.StudioAgentPresetR\x06agents\"f\n" +
	"\x1cSetStudioAgentPresetsRequest\x12F\n" +
	"\x06agents\x18\x01 \x03(\v2..buf.alpha.registry.v1alpha1.StudioAgentPresetR\x06agents\"\x1f\n" +
	"\x1dSetStudioAgentPresetsResponse*\x7f\n" +
	"\x13StudioAgentProtocol\x12%\n" +
	"!STUDIO_AGENT_PROTOCOL_UNSPECIFIED\x10\x00\x12\x1e\n" +
	"\x1aSTUDIO_AGENT_PROTOCOL_GRPC\x10\x01\x12!\n" +
	"\x1dSTUDIO_AGENT_PROTOCOL_CONNECT\x10\x022\xb9\x02\n" +
	"\rStudioService\x12\x96\x01\n" +
	"\x16ListStudioAgentPresets\x12:.buf.alpha.registry.v1alpha1.ListStudioAgentPresetsRequest\x1a;.buf.alpha.registry.v1alpha1.ListStudioAgentPresetsResponse\"\x03\x90\x02\x01\x12\x8e\x01\n" +
	"\x15SetStudioAgentPresets\x129.buf.alpha.registry.v1alpha1.SetStudioAgentPresetsRequest\x1a:.buf.alpha.registry.v1alpha1.SetStudioAgentPresetsResponseB\x98\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\vStudioProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_studio_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_buf_alpha_registry_v1alpha1_studio_proto_goTypes = []any{
	(StudioAgentProtocol)(0),               // 0: buf.alpha.registry.v1alpha1.StudioAgentProtocol
	(*StudioAgentPreset)(nil),              // 1: buf.alpha.registry.v1alpha1.StudioAgentPreset
	(*ListStudioAgentPresetsRequest)(nil),  // 2: buf.alpha.registry.v1alpha1.ListStudioAgentPresetsRequest
	(*ListStudioAgentPresetsResponse)(nil), // 3: buf.alpha.registry.v1alpha1.ListStudioAgentPresetsResponse
	(*SetStudioAgentPresetsRequest)(nil),   // 4: buf.alpha.registry.v1alpha1.SetStudioAgentPresetsRequest
	(*SetStudioAgentPresetsResponse)(nil),  // 5: buf.alpha.registry.v1alpha1.SetStudioAgentPresetsResponse
}
var file_buf_alpha_registry_v1alpha1_studio_proto_depIdxs = []int32{
	0, // 0: buf.alpha.registry.v1alpha1.StudioAgentPreset.protocol:type_name -> buf.alpha.registry.v1alpha1.StudioAgentProtocol
	1, // 1: buf.alpha.registry.v1alpha1.ListStudioAgentPresetsResponse.agents:type_name -> buf.alpha.registry.v1alpha1.StudioAgentPreset
	1, // 2: buf.alpha.registry.v1alpha1.SetStudioAgentPresetsRequest.agents:type_name -> buf.alpha.registry.v1alpha1.StudioAgentPreset
	2, // 3: buf.alpha.registry.v1alpha1.StudioService.ListStudioAgentPresets:input_type -> buf.alpha.registry.v1alpha1.ListStudioAgentPresetsRequest
	4, // 4: buf.alpha.registry.v1alpha1.StudioService.SetStudioAgentPresets:input_type -> buf.alpha.registry.v1alpha1.SetStudioAgentPresetsRequest
	3, // 5: buf.alpha.registry.v1alpha1.StudioService.ListStudioAgentPresets:output_type -> buf.alpha.registry.v1alpha1.ListStudioAgentPresetsResponse
	5, // 6: buf.alpha.registry.v1alpha1.StudioService.SetStudioAgentPresets:output_type -> buf.alpha.registry.v1alpha1.SetStudioAgentPresetsResponse
	5, // [5:7] is the sub-list for method output_type
	3, // [3:5] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_studio_proto_init() }
func file_buf_alpha_registry_v1alpha1_studio_proto_init() {
	if File_buf_alpha_registry_v1alpha1_studio_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_studio_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_studio_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_studio_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_studio_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_studio_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_studio_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_studio_proto = out.File
	file_buf_alpha_registry_v1alpha1_studio_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_studio_proto_depIdxs = nil
}
