// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the allocation rules in an IPAM policy.
//
// An IPAM policy is a set of rules that define how public IPv4 addresses from
// IPAM pools are allocated to Amazon Web Services resources. Each rule maps an
// Amazon Web Services service to IPAM pools that the service will use to get IP
// addresses. A single policy can have multiple rules and be applied to multiple
// Amazon Web Services Regions. If the IPAM pool run out of addresses then the
// services fallback to Amazon-provided IP addresses. A policy can be applied to an
// individual Amazon Web Services account or an entity within Amazon Web Services
// Organizations.
//
// Allocation rules are optional configurations within an IPAM policy that map
// Amazon Web Services resource types to specific IPAM pools. If no rules are
// defined, the resource types default to using Amazon-provided IP addresses.
func (c *Client) ModifyIpamPolicyAllocationRules(ctx context.Context, params *ModifyIpamPolicyAllocationRulesInput, optFns ...func(*Options)) (*ModifyIpamPolicyAllocationRulesOutput, error) {
	if params == nil {
		params = &ModifyIpamPolicyAllocationRulesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyIpamPolicyAllocationRules", params, optFns, c.addOperationModifyIpamPolicyAllocationRulesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyIpamPolicyAllocationRulesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifyIpamPolicyAllocationRulesInput struct {

	// The ID of the IPAM policy whose allocation rules you want to modify.
	//
	// This member is required.
	IpamPolicyId *string

	// The locale for which to modify the allocation rules.
	//
	// This member is required.
	Locale *string

	// The resource type for which to modify the allocation rules.
	//
	// The Amazon Web Services service or resource type that can use IP addresses
	// through IPAM policies. Supported services and resource types include:
	//
	//   - Elastic IP addresses
	//
	// This member is required.
	ResourceType types.IpamPolicyResourceType

	// The new allocation rules to apply to the IPAM policy.
	//
	// Allocation rules are optional configurations within an IPAM policy that map
	// Amazon Web Services resource types to specific IPAM pools. If no rules are
	// defined, the resource types default to using Amazon-provided IP addresses.
	AllocationRules []types.IpamPolicyAllocationRuleRequest

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	noSmithyDocumentSerde
}

type ModifyIpamPolicyAllocationRulesOutput struct {

	// The modified IPAM policy containing the updated allocation rules.
	IpamPolicyDocument *types.IpamPolicyDocument

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyIpamPolicyAllocationRulesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpModifyIpamPolicyAllocationRules{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpModifyIpamPolicyAllocationRules{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifyIpamPolicyAllocationRules"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpModifyIpamPolicyAllocationRulesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyIpamPolicyAllocationRules(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyIpamPolicyAllocationRules(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifyIpamPolicyAllocationRules",
	}
}
