package vulnerability

import (
	"github.com/aquasecurity/trivy-db/pkg/types"
)

const (
	// Data source
	NVD                   types.SourceID = "nvd"
	RedHat                types.SourceID = "redhat"
	RedHatOVAL            types.SourceID = "redhat-oval"
	Debian                types.SourceID = "debian"
	Ubuntu                types.SourceID = "ubuntu"
	CentOS                types.SourceID = "centos"
	Rocky                 types.SourceID = "rocky"
	Fedora                types.SourceID = "fedora"
	Amazon                types.SourceID = "amazon"
	OracleOVAL            types.SourceID = "oracle-oval"
	SuseCVRF              types.SourceID = "suse-cvrf"
	Alpine                types.SourceID = "alpine"
	ArchLinux             types.SourceID = "arch-linux"
	Alma                  types.SourceID = "alma"
	AzureLinux            types.SourceID = "azure"
	CBLMariner            types.SourceID = "cbl-mariner"
	Photon                types.SourceID = "photon"
	RubySec               types.SourceID = "ruby-advisory-db"
	PhpSecurityAdvisories types.SourceID = "php-security-advisories"
	NodejsSecurityWg      types.SourceID = "nodejs-security-wg"
	GHSA                  types.SourceID = "ghsa"
	GLAD                  types.SourceID = "glad"
	OSV                   types.SourceID = "osv"
	Wolfi                 types.SourceID = "wolfi"
	Chainguard            types.SourceID = "chainguard"
	BitnamiVulndb         types.SourceID = "bitnami"
	K8sVulnDB             types.SourceID = "k8s"
	GoVulnDB              types.SourceID = "govulndb"
	Seal                  types.SourceID = "seal"
	Aqua                  types.SourceID = "aqua"
	Echo                  types.SourceID = "echo"
	MinimOS               types.SourceID = "minimos"
	RootIO                types.SourceID = "rootio"
)

// AllSourceIDs lists all supported vulnerability source IDs in order of precedence.
// When searching for vulnerability details (Severity, Title, Description, and CWE-IDs),
// the sources are checked in this order until valid data is found.
// For example, if severity data is missing in NVD, it will check Red Hat next,
// continuing through the list until it finds a valid severity value.
var AllSourceIDs = []types.SourceID{
	NVD,
	RedHat,
	RedHatOVAL,
	Debian,
	Ubuntu,
	Alpine,
	Amazon,
	OracleOVAL,
	SuseCVRF,
	Photon,
	ArchLinux,
	Alma,
	Rocky,
	CBLMariner,
	AzureLinux,
	RubySec,
	PhpSecurityAdvisories,
	NodejsSecurityWg,
	GHSA,
	GLAD,
	Aqua,
	OSV,
	K8sVulnDB,
	Wolfi,
	Chainguard,
	BitnamiVulndb,
	GoVulnDB,
	Echo,
	MinimOS,
	RootIO,
}
