package builtin.github.repositories.github0003_test

import rego.v1

import data.builtin.github.repositories.github0003 as check

test_allow_vulnerability_alerts_enabled if {
	inp := {"github": {"repositories": [{
		"vulnerabilityalerts": {"value": true},
		"archived": {"value": false},
	}]}}

	res := check.deny with input as inp
	res == set()
}

test_allow_vulnerability_alerts_disabled_for_archived_repository if {
	inp := {"github": {"repositories": [{
		"vulnerabilityalerts": {"value": false},
		"archived": {"value": true},
	}]}}

	res := check.deny with input as inp
	res == set()
}

test_deny_vulnerability_alerts_disabled if {
	inp := {"github": {"repositories": [{
		"vulnerabilityalerts": {"value": false},
		"archived": {"value": false},
	}]}}

	res := check.deny with input as inp
	count(res) == 1
}
