// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/registry/policy/v1beta1/policy_service.proto

//go:build protoopaque

package policyv1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	v1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListPoliciesRequest_Order int32

const (
	ListPoliciesRequest_ORDER_UNSPECIFIED ListPoliciesRequest_Order = 0
	// Order by create_time newest to oldest.
	ListPoliciesRequest_ORDER_CREATE_TIME_DESC ListPoliciesRequest_Order = 1
	// Order by create_time oldest to newest.
	ListPoliciesRequest_ORDER_CREATE_TIME_ASC ListPoliciesRequest_Order = 2
)

// Enum value maps for ListPoliciesRequest_Order.
var (
	ListPoliciesRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListPoliciesRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListPoliciesRequest_Order) Enum() *ListPoliciesRequest_Order {
	p := new(ListPoliciesRequest_Order)
	*p = x
	return p
}

func (x ListPoliciesRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListPoliciesRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_policy_v1beta1_policy_service_proto_enumTypes[0].Descriptor()
}

func (ListPoliciesRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_policy_v1beta1_policy_service_proto_enumTypes[0]
}

func (x ListPoliciesRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetPoliciesRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PolicyRefs *[]*PolicyRef          `protobuf:"bytes,1,rep,name=policy_refs,json=policyRefs,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetPoliciesRequest) Reset() {
	*x = GetPoliciesRequest{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPoliciesRequest) ProtoMessage() {}

func (x *GetPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPoliciesRequest) GetPolicyRefs() []*PolicyRef {
	if x != nil {
		if x.xxx_hidden_PolicyRefs != nil {
			return *x.xxx_hidden_PolicyRefs
		}
	}
	return nil
}

func (x *GetPoliciesRequest) SetPolicyRefs(v []*PolicyRef) {
	x.xxx_hidden_PolicyRefs = &v
}

type GetPoliciesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Policies to request.
	PolicyRefs []*PolicyRef
}

func (b0 GetPoliciesRequest_builder) Build() *GetPoliciesRequest {
	m0 := &GetPoliciesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PolicyRefs = &b.PolicyRefs
	return m0
}

type GetPoliciesResponse struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Policies *[]*Policy             `protobuf:"bytes,1,rep,name=policies,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *GetPoliciesResponse) Reset() {
	*x = GetPoliciesResponse{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPoliciesResponse) ProtoMessage() {}

func (x *GetPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPoliciesResponse) GetPolicies() []*Policy {
	if x != nil {
		if x.xxx_hidden_Policies != nil {
			return *x.xxx_hidden_Policies
		}
	}
	return nil
}

func (x *GetPoliciesResponse) SetPolicies(v []*Policy) {
	x.xxx_hidden_Policies = &v
}

type GetPoliciesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The retrieved Policies in the same order as requested.
	Policies []*Policy
}

func (b0 GetPoliciesResponse_builder) Build() *GetPoliciesResponse {
	m0 := &GetPoliciesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Policies = &b.Policies
	return m0
}

type ListPoliciesRequest struct {
	state                protoimpl.MessageState    `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                    `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                    `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_OwnerRefs *[]*v1.OwnerRef           `protobuf:"bytes,3,rep,name=owner_refs,json=ownerRefs,proto3"`
	xxx_hidden_Order     ListPoliciesRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.policy.v1beta1.ListPoliciesRequest_Order"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListPoliciesRequest) Reset() {
	*x = ListPoliciesRequest{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPoliciesRequest) ProtoMessage() {}

func (x *ListPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListPoliciesRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListPoliciesRequest) GetOwnerRefs() []*v1.OwnerRef {
	if x != nil {
		if x.xxx_hidden_OwnerRefs != nil {
			return *x.xxx_hidden_OwnerRefs
		}
	}
	return nil
}

func (x *ListPoliciesRequest) GetOrder() ListPoliciesRequest_Order {
	if x != nil {
		return x.xxx_hidden_Order
	}
	return ListPoliciesRequest_ORDER_UNSPECIFIED
}

func (x *ListPoliciesRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListPoliciesRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListPoliciesRequest) SetOwnerRefs(v []*v1.OwnerRef) {
	x.xxx_hidden_OwnerRefs = &v
}

func (x *ListPoliciesRequest) SetOrder(v ListPoliciesRequest_Order) {
	x.xxx_hidden_Order = v
}

type ListPoliciesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string
	// The specific Users or Organizations to list Policies for.
	//
	// If empty, all Policies for all owners are listed, but this functionality
	// is limited to Users with the necessary permissions.
	OwnerRefs []*v1.OwnerRef
	// The order to return the Policies.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListPoliciesRequest_Order
}

func (b0 ListPoliciesRequest_builder) Build() *ListPoliciesRequest {
	m0 := &ListPoliciesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_OwnerRefs = &b.OwnerRefs
	x.xxx_hidden_Order = b.Order
	return m0
}

type ListPoliciesResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3"`
	xxx_hidden_Policies      *[]*Policy             `protobuf:"bytes,2,rep,name=policies,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListPoliciesResponse) Reset() {
	*x = ListPoliciesResponse{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPoliciesResponse) ProtoMessage() {}

func (x *ListPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListPoliciesResponse) GetPolicies() []*Policy {
	if x != nil {
		if x.xxx_hidden_Policies != nil {
			return *x.xxx_hidden_Policies
		}
	}
	return nil
}

func (x *ListPoliciesResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

func (x *ListPoliciesResponse) SetPolicies(v []*Policy) {
	x.xxx_hidden_Policies = &v
}

type ListPoliciesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The listed Policies.
	Policies []*Policy
}

func (b0 ListPoliciesResponse_builder) Build() *ListPoliciesResponse {
	m0 := &ListPoliciesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_NextPageToken = b.NextPageToken
	x.xxx_hidden_Policies = &b.Policies
	return m0
}

type CreatePoliciesRequest struct {
	state             protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_Values *[]*CreatePoliciesRequest_Value `protobuf:"bytes,1,rep,name=values,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *CreatePoliciesRequest) Reset() {
	*x = CreatePoliciesRequest{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePoliciesRequest) ProtoMessage() {}

func (x *CreatePoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreatePoliciesRequest) GetValues() []*CreatePoliciesRequest_Value {
	if x != nil {
		if x.xxx_hidden_Values != nil {
			return *x.xxx_hidden_Values
		}
	}
	return nil
}

func (x *CreatePoliciesRequest) SetValues(v []*CreatePoliciesRequest_Value) {
	x.xxx_hidden_Values = &v
}

type CreatePoliciesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Policies to create.
	Values []*CreatePoliciesRequest_Value
}

func (b0 CreatePoliciesRequest_builder) Build() *CreatePoliciesRequest {
	m0 := &CreatePoliciesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Values = &b.Values
	return m0
}

type CreatePoliciesResponse struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Policies *[]*Policy             `protobuf:"bytes,1,rep,name=policies,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *CreatePoliciesResponse) Reset() {
	*x = CreatePoliciesResponse{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePoliciesResponse) ProtoMessage() {}

func (x *CreatePoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreatePoliciesResponse) GetPolicies() []*Policy {
	if x != nil {
		if x.xxx_hidden_Policies != nil {
			return *x.xxx_hidden_Policies
		}
	}
	return nil
}

func (x *CreatePoliciesResponse) SetPolicies(v []*Policy) {
	x.xxx_hidden_Policies = &v
}

type CreatePoliciesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The created Policies in the same order as given on the request.
	Policies []*Policy
}

func (b0 CreatePoliciesResponse_builder) Build() *CreatePoliciesResponse {
	m0 := &CreatePoliciesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Policies = &b.Policies
	return m0
}

type UpdatePoliciesRequest struct {
	state             protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_Values *[]*UpdatePoliciesRequest_Value `protobuf:"bytes,1,rep,name=values,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *UpdatePoliciesRequest) Reset() {
	*x = UpdatePoliciesRequest{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePoliciesRequest) ProtoMessage() {}

func (x *UpdatePoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdatePoliciesRequest) GetValues() []*UpdatePoliciesRequest_Value {
	if x != nil {
		if x.xxx_hidden_Values != nil {
			return *x.xxx_hidden_Values
		}
	}
	return nil
}

func (x *UpdatePoliciesRequest) SetValues(v []*UpdatePoliciesRequest_Value) {
	x.xxx_hidden_Values = &v
}

type UpdatePoliciesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Policies to update.
	Values []*UpdatePoliciesRequest_Value
}

func (b0 UpdatePoliciesRequest_builder) Build() *UpdatePoliciesRequest {
	m0 := &UpdatePoliciesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Values = &b.Values
	return m0
}

type UpdatePoliciesResponse struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Policies *[]*Policy             `protobuf:"bytes,1,rep,name=policies,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *UpdatePoliciesResponse) Reset() {
	*x = UpdatePoliciesResponse{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePoliciesResponse) ProtoMessage() {}

func (x *UpdatePoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdatePoliciesResponse) GetPolicies() []*Policy {
	if x != nil {
		if x.xxx_hidden_Policies != nil {
			return *x.xxx_hidden_Policies
		}
	}
	return nil
}

func (x *UpdatePoliciesResponse) SetPolicies(v []*Policy) {
	x.xxx_hidden_Policies = &v
}

type UpdatePoliciesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The updated Policies in the same order as given in the request.
	Policies []*Policy
}

func (b0 UpdatePoliciesResponse_builder) Build() *UpdatePoliciesResponse {
	m0 := &UpdatePoliciesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Policies = &b.Policies
	return m0
}

type DeletePoliciesRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PolicyRefs *[]*PolicyRef          `protobuf:"bytes,1,rep,name=policy_refs,json=policyRefs,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *DeletePoliciesRequest) Reset() {
	*x = DeletePoliciesRequest{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePoliciesRequest) ProtoMessage() {}

func (x *DeletePoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeletePoliciesRequest) GetPolicyRefs() []*PolicyRef {
	if x != nil {
		if x.xxx_hidden_PolicyRefs != nil {
			return *x.xxx_hidden_PolicyRefs
		}
	}
	return nil
}

func (x *DeletePoliciesRequest) SetPolicyRefs(v []*PolicyRef) {
	x.xxx_hidden_PolicyRefs = &v
}

type DeletePoliciesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Policies to delete.
	PolicyRefs []*PolicyRef
}

func (b0 DeletePoliciesRequest_builder) Build() *DeletePoliciesRequest {
	m0 := &DeletePoliciesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PolicyRefs = &b.PolicyRefs
	return m0
}

type DeletePoliciesResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeletePoliciesResponse) Reset() {
	*x = DeletePoliciesResponse{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePoliciesResponse) ProtoMessage() {}

func (x *DeletePoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeletePoliciesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeletePoliciesResponse_builder) Build() *DeletePoliciesResponse {
	m0 := &DeletePoliciesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// An individual request to create a Policy.
type CreatePoliciesRequest_Value struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerRef    *v1.OwnerRef           `protobuf:"bytes,1,opt,name=owner_ref,json=ownerRef,proto3"`
	xxx_hidden_Name        string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Visibility  PolicyVisibility       `protobuf:"varint,3,opt,name=visibility,proto3,enum=buf.registry.policy.v1beta1.PolicyVisibility"`
	xxx_hidden_Description string                 `protobuf:"bytes,4,opt,name=description,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *CreatePoliciesRequest_Value) Reset() {
	*x = CreatePoliciesRequest_Value{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePoliciesRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePoliciesRequest_Value) ProtoMessage() {}

func (x *CreatePoliciesRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreatePoliciesRequest_Value) GetOwnerRef() *v1.OwnerRef {
	if x != nil {
		return x.xxx_hidden_OwnerRef
	}
	return nil
}

func (x *CreatePoliciesRequest_Value) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *CreatePoliciesRequest_Value) GetVisibility() PolicyVisibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return PolicyVisibility_POLICY_VISIBILITY_UNSPECIFIED
}

func (x *CreatePoliciesRequest_Value) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *CreatePoliciesRequest_Value) SetOwnerRef(v *v1.OwnerRef) {
	x.xxx_hidden_OwnerRef = v
}

func (x *CreatePoliciesRequest_Value) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *CreatePoliciesRequest_Value) SetVisibility(v PolicyVisibility) {
	x.xxx_hidden_Visibility = v
}

func (x *CreatePoliciesRequest_Value) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *CreatePoliciesRequest_Value) HasOwnerRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_OwnerRef != nil
}

func (x *CreatePoliciesRequest_Value) ClearOwnerRef() {
	x.xxx_hidden_OwnerRef = nil
}

type CreatePoliciesRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The User or Organization to create the Policy under.
	OwnerRef *v1.OwnerRef
	// The name of the Policy.
	Name string
	// The Policy's visibility.
	Visibility PolicyVisibility
	// The configurable description of the Policy.
	Description string
}

func (b0 CreatePoliciesRequest_Value_builder) Build() *CreatePoliciesRequest_Value {
	m0 := &CreatePoliciesRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerRef = b.OwnerRef
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_Description = b.Description
	return m0
}

// An individual request to update a Policy.
type UpdatePoliciesRequest_Value struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PolicyRef   *PolicyRef             `protobuf:"bytes,1,opt,name=policy_ref,json=policyRef,proto3"`
	xxx_hidden_Visibility  PolicyVisibility       `protobuf:"varint,2,opt,name=visibility,proto3,enum=buf.registry.policy.v1beta1.PolicyVisibility,oneof"`
	xxx_hidden_State       PolicyState            `protobuf:"varint,4,opt,name=state,proto3,enum=buf.registry.policy.v1beta1.PolicyState,oneof"`
	xxx_hidden_Description *string                `protobuf:"bytes,5,opt,name=description,proto3,oneof"`
	XXX_raceDetectHookData protoimpl.RaceDetectHookData
	XXX_presence           [1]uint32
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *UpdatePoliciesRequest_Value) Reset() {
	*x = UpdatePoliciesRequest_Value{}
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePoliciesRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePoliciesRequest_Value) ProtoMessage() {}

func (x *UpdatePoliciesRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdatePoliciesRequest_Value) GetPolicyRef() *PolicyRef {
	if x != nil {
		return x.xxx_hidden_PolicyRef
	}
	return nil
}

func (x *UpdatePoliciesRequest_Value) GetVisibility() PolicyVisibility {
	if x != nil {
		if protoimpl.X.Present(&(x.XXX_presence[0]), 1) {
			return x.xxx_hidden_Visibility
		}
	}
	return PolicyVisibility_POLICY_VISIBILITY_UNSPECIFIED
}

func (x *UpdatePoliciesRequest_Value) GetState() PolicyState {
	if x != nil {
		if protoimpl.X.Present(&(x.XXX_presence[0]), 2) {
			return x.xxx_hidden_State
		}
	}
	return PolicyState_POLICY_STATE_UNSPECIFIED
}

func (x *UpdatePoliciesRequest_Value) GetDescription() string {
	if x != nil {
		if x.xxx_hidden_Description != nil {
			return *x.xxx_hidden_Description
		}
		return ""
	}
	return ""
}

func (x *UpdatePoliciesRequest_Value) SetPolicyRef(v *PolicyRef) {
	x.xxx_hidden_PolicyRef = v
}

func (x *UpdatePoliciesRequest_Value) SetVisibility(v PolicyVisibility) {
	x.xxx_hidden_Visibility = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 1, 4)
}

func (x *UpdatePoliciesRequest_Value) SetState(v PolicyState) {
	x.xxx_hidden_State = v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 2, 4)
}

func (x *UpdatePoliciesRequest_Value) SetDescription(v string) {
	x.xxx_hidden_Description = &v
	protoimpl.X.SetPresent(&(x.XXX_presence[0]), 3, 4)
}

func (x *UpdatePoliciesRequest_Value) HasPolicyRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_PolicyRef != nil
}

func (x *UpdatePoliciesRequest_Value) HasVisibility() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 1)
}

func (x *UpdatePoliciesRequest_Value) HasState() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 2)
}

func (x *UpdatePoliciesRequest_Value) HasDescription() bool {
	if x == nil {
		return false
	}
	return protoimpl.X.Present(&(x.XXX_presence[0]), 3)
}

func (x *UpdatePoliciesRequest_Value) ClearPolicyRef() {
	x.xxx_hidden_PolicyRef = nil
}

func (x *UpdatePoliciesRequest_Value) ClearVisibility() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 1)
	x.xxx_hidden_Visibility = PolicyVisibility_POLICY_VISIBILITY_UNSPECIFIED
}

func (x *UpdatePoliciesRequest_Value) ClearState() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 2)
	x.xxx_hidden_State = PolicyState_POLICY_STATE_UNSPECIFIED
}

func (x *UpdatePoliciesRequest_Value) ClearDescription() {
	protoimpl.X.ClearPresent(&(x.XXX_presence[0]), 3)
	x.xxx_hidden_Description = nil
}

type UpdatePoliciesRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Policy to update.
	PolicyRef *PolicyRef
	// The Policy's visibility.
	Visibility *PolicyVisibility
	// The deprecation status of the Policy.
	State *PolicyState
	// The configurable description of the Policy.
	Description *string
}

func (b0 UpdatePoliciesRequest_Value_builder) Build() *UpdatePoliciesRequest_Value {
	m0 := &UpdatePoliciesRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PolicyRef = b.PolicyRef
	if b.Visibility != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 1, 4)
		x.xxx_hidden_Visibility = *b.Visibility
	}
	if b.State != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 2, 4)
		x.xxx_hidden_State = *b.State
	}
	if b.Description != nil {
		protoimpl.X.SetPresentNonAtomic(&(x.XXX_presence[0]), 3, 4)
		x.xxx_hidden_Description = b.Description
	}
	return m0
}

var File_buf_registry_policy_v1beta1_policy_service_proto protoreflect.FileDescriptor

const file_buf_registry_policy_v1beta1_policy_service_proto_rawDesc = "" +
	"\n" +
	"0buf/registry/policy/v1beta1/policy_service.proto\x12\x1bbuf.registry.policy.v1beta1\x1a!buf/registry/owner/v1/owner.proto\x1a(buf/registry/policy/v1beta1/policy.proto\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\"r\n" +
	"\x12GetPoliciesRequest\x12T\n" +
	"\vpolicy_refs\x18\x01 \x03(\v2&.buf.registry.policy.v1beta1.PolicyRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\n" +
	"policyRefs:\x06\xea\xc5+\x02\b\x01\"h\n" +
	"\x13GetPoliciesResponse\x12I\n" +
	"\bpolicies\x18\x01 \x03(\v2#.buf.registry.policy.v1beta1.PolicyB\b\xbaH\x05\x92\x01\x02\b\x01R\bpolicies:\x06\xea\xc5+\x02\x10\x01\"\xdc\x02\n" +
	"\x13ListPoliciesRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xfa\x01R\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\x12>\n" +
	"\n" +
	"owner_refs\x18\x03 \x03(\v2\x1f.buf.registry.owner.v1.OwnerRefR\townerRefs\x12V\n" +
	"\x05order\x18\x04 \x01(\x0e26.buf.registry.policy.v1beta1.ListPoliciesRequest.OrderB\b\xbaH\x05\x82\x01\x02\x10\x01R\x05order\"U\n" +
	"\x05Order\x12\x15\n" +
	"\x11ORDER_UNSPECIFIED\x10\x00\x12\x1a\n" +
	"\x16ORDER_CREATE_TIME_DESC\x10\x01\x12\x19\n" +
	"\x15ORDER_CREATE_TIME_ASC\x10\x02:\x06\xea\xc5+\x02\b\x01\"\x91\x01\n" +
	"\x14ListPoliciesResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x12?\n" +
	"\bpolicies\x18\x02 \x03(\v2#.buf.registry.policy.v1beta1.PolicyR\bpolicies:\x06\xea\xc5+\x02\x10\x01\"\xf5\x02\n" +
	"\x15CreatePoliciesRequest\x12]\n" +
	"\x06values\x18\x01 \x03(\v28.buf.registry.policy.v1beta1.CreatePoliciesRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\xf4\x01\n" +
	"\x05Value\x12D\n" +
	"\towner_ref\x18\x01 \x01(\v2\x1f.buf.registry.owner.v1.OwnerRefB\x06\xbaH\x03\xc8\x01\x01R\bownerRef\x12\x1d\n" +
	"\x04name\x18\x02 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x04name\x12Z\n" +
	"\n" +
	"visibility\x18\x03 \x01(\x0e2-.buf.registry.policy.v1beta1.PolicyVisibilityB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\n" +
	"visibility\x12*\n" +
	"\vdescription\x18\x04 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription:\x06\xea\xc5+\x02\b\x01\"k\n" +
	"\x16CreatePoliciesResponse\x12I\n" +
	"\bpolicies\x18\x01 \x03(\v2#.buf.registry.policy.v1beta1.PolicyB\b\xbaH\x05\x92\x01\x02\b\x01R\bpolicies:\x06\xea\xc5+\x02\x10\x01\"\xe2\x03\n" +
	"\x15UpdatePoliciesRequest\x12]\n" +
	"\x06values\x18\x01 \x03(\v28.buf.registry.policy.v1beta1.UpdatePoliciesRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\xe1\x02\n" +
	"\x05Value\x12M\n" +
	"\n" +
	"policy_ref\x18\x01 \x01(\v2&.buf.registry.policy.v1beta1.PolicyRefB\x06\xbaH\x03\xc8\x01\x01R\tpolicyRef\x12^\n" +
	"\n" +
	"visibility\x18\x02 \x01(\x0e2-.buf.registry.policy.v1beta1.PolicyVisibilityB\n" +
	"\xbaH\a\x82\x01\x04\x10\x01 \x00H\x00R\n" +
	"visibility\x88\x01\x01\x12O\n" +
	"\x05state\x18\x04 \x01(\x0e2(.buf.registry.policy.v1beta1.PolicyStateB\n" +
	"\xbaH\a\x82\x01\x04\x10\x01 \x00H\x01R\x05state\x88\x01\x01\x12/\n" +
	"\vdescription\x18\x05 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02H\x02R\vdescription\x88\x01\x01B\r\n" +
	"\v_visibilityB\b\n" +
	"\x06_stateB\x0e\n" +
	"\f_description:\x06\xea\xc5+\x02\b\x01\"k\n" +
	"\x16UpdatePoliciesResponse\x12I\n" +
	"\bpolicies\x18\x01 \x03(\v2#.buf.registry.policy.v1beta1.PolicyB\b\xbaH\x05\x92\x01\x02\b\x01R\bpolicies:\x06\xea\xc5+\x02\x10\x01\"u\n" +
	"\x15DeletePoliciesRequest\x12T\n" +
	"\vpolicy_refs\x18\x01 \x03(\v2&.buf.registry.policy.v1beta1.PolicyRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\n" +
	"policyRefs:\x06\xea\xc5+\x02\b\x01\" \n" +
	"\x16DeletePoliciesResponse:\x06\xea\xc5+\x02\x10\x012\x80\x05\n" +
	"\rPolicyService\x12u\n" +
	"\vGetPolicies\x12/.buf.registry.policy.v1beta1.GetPoliciesRequest\x1a0.buf.registry.policy.v1beta1.GetPoliciesResponse\"\x03\x90\x02\x01\x12x\n" +
	"\fListPolicies\x120.buf.registry.policy.v1beta1.ListPoliciesRequest\x1a1.buf.registry.policy.v1beta1.ListPoliciesResponse\"\x03\x90\x02\x01\x12~\n" +
	"\x0eCreatePolicies\x122.buf.registry.policy.v1beta1.CreatePoliciesRequest\x1a3.buf.registry.policy.v1beta1.CreatePoliciesResponse\"\x03\x90\x02\x02\x12~\n" +
	"\x0eUpdatePolicies\x122.buf.registry.policy.v1beta1.UpdatePoliciesRequest\x1a3.buf.registry.policy.v1beta1.UpdatePoliciesResponse\"\x03\x90\x02\x02\x12~\n" +
	"\x0eDeletePolicies\x122.buf.registry.policy.v1beta1.DeletePoliciesRequest\x1a3.buf.registry.policy.v1beta1.DeletePoliciesResponse\"\x03\x90\x02\x02BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/policy/v1beta1;policyv1beta1b\x06proto3"

var file_buf_registry_policy_v1beta1_policy_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_buf_registry_policy_v1beta1_policy_service_proto_goTypes = []any{
	(ListPoliciesRequest_Order)(0),      // 0: buf.registry.policy.v1beta1.ListPoliciesRequest.Order
	(*GetPoliciesRequest)(nil),          // 1: buf.registry.policy.v1beta1.GetPoliciesRequest
	(*GetPoliciesResponse)(nil),         // 2: buf.registry.policy.v1beta1.GetPoliciesResponse
	(*ListPoliciesRequest)(nil),         // 3: buf.registry.policy.v1beta1.ListPoliciesRequest
	(*ListPoliciesResponse)(nil),        // 4: buf.registry.policy.v1beta1.ListPoliciesResponse
	(*CreatePoliciesRequest)(nil),       // 5: buf.registry.policy.v1beta1.CreatePoliciesRequest
	(*CreatePoliciesResponse)(nil),      // 6: buf.registry.policy.v1beta1.CreatePoliciesResponse
	(*UpdatePoliciesRequest)(nil),       // 7: buf.registry.policy.v1beta1.UpdatePoliciesRequest
	(*UpdatePoliciesResponse)(nil),      // 8: buf.registry.policy.v1beta1.UpdatePoliciesResponse
	(*DeletePoliciesRequest)(nil),       // 9: buf.registry.policy.v1beta1.DeletePoliciesRequest
	(*DeletePoliciesResponse)(nil),      // 10: buf.registry.policy.v1beta1.DeletePoliciesResponse
	(*CreatePoliciesRequest_Value)(nil), // 11: buf.registry.policy.v1beta1.CreatePoliciesRequest.Value
	(*UpdatePoliciesRequest_Value)(nil), // 12: buf.registry.policy.v1beta1.UpdatePoliciesRequest.Value
	(*PolicyRef)(nil),                   // 13: buf.registry.policy.v1beta1.PolicyRef
	(*Policy)(nil),                      // 14: buf.registry.policy.v1beta1.Policy
	(*v1.OwnerRef)(nil),                 // 15: buf.registry.owner.v1.OwnerRef
	(PolicyVisibility)(0),               // 16: buf.registry.policy.v1beta1.PolicyVisibility
	(PolicyState)(0),                    // 17: buf.registry.policy.v1beta1.PolicyState
}
var file_buf_registry_policy_v1beta1_policy_service_proto_depIdxs = []int32{
	13, // 0: buf.registry.policy.v1beta1.GetPoliciesRequest.policy_refs:type_name -> buf.registry.policy.v1beta1.PolicyRef
	14, // 1: buf.registry.policy.v1beta1.GetPoliciesResponse.policies:type_name -> buf.registry.policy.v1beta1.Policy
	15, // 2: buf.registry.policy.v1beta1.ListPoliciesRequest.owner_refs:type_name -> buf.registry.owner.v1.OwnerRef
	0,  // 3: buf.registry.policy.v1beta1.ListPoliciesRequest.order:type_name -> buf.registry.policy.v1beta1.ListPoliciesRequest.Order
	14, // 4: buf.registry.policy.v1beta1.ListPoliciesResponse.policies:type_name -> buf.registry.policy.v1beta1.Policy
	11, // 5: buf.registry.policy.v1beta1.CreatePoliciesRequest.values:type_name -> buf.registry.policy.v1beta1.CreatePoliciesRequest.Value
	14, // 6: buf.registry.policy.v1beta1.CreatePoliciesResponse.policies:type_name -> buf.registry.policy.v1beta1.Policy
	12, // 7: buf.registry.policy.v1beta1.UpdatePoliciesRequest.values:type_name -> buf.registry.policy.v1beta1.UpdatePoliciesRequest.Value
	14, // 8: buf.registry.policy.v1beta1.UpdatePoliciesResponse.policies:type_name -> buf.registry.policy.v1beta1.Policy
	13, // 9: buf.registry.policy.v1beta1.DeletePoliciesRequest.policy_refs:type_name -> buf.registry.policy.v1beta1.PolicyRef
	15, // 10: buf.registry.policy.v1beta1.CreatePoliciesRequest.Value.owner_ref:type_name -> buf.registry.owner.v1.OwnerRef
	16, // 11: buf.registry.policy.v1beta1.CreatePoliciesRequest.Value.visibility:type_name -> buf.registry.policy.v1beta1.PolicyVisibility
	13, // 12: buf.registry.policy.v1beta1.UpdatePoliciesRequest.Value.policy_ref:type_name -> buf.registry.policy.v1beta1.PolicyRef
	16, // 13: buf.registry.policy.v1beta1.UpdatePoliciesRequest.Value.visibility:type_name -> buf.registry.policy.v1beta1.PolicyVisibility
	17, // 14: buf.registry.policy.v1beta1.UpdatePoliciesRequest.Value.state:type_name -> buf.registry.policy.v1beta1.PolicyState
	1,  // 15: buf.registry.policy.v1beta1.PolicyService.GetPolicies:input_type -> buf.registry.policy.v1beta1.GetPoliciesRequest
	3,  // 16: buf.registry.policy.v1beta1.PolicyService.ListPolicies:input_type -> buf.registry.policy.v1beta1.ListPoliciesRequest
	5,  // 17: buf.registry.policy.v1beta1.PolicyService.CreatePolicies:input_type -> buf.registry.policy.v1beta1.CreatePoliciesRequest
	7,  // 18: buf.registry.policy.v1beta1.PolicyService.UpdatePolicies:input_type -> buf.registry.policy.v1beta1.UpdatePoliciesRequest
	9,  // 19: buf.registry.policy.v1beta1.PolicyService.DeletePolicies:input_type -> buf.registry.policy.v1beta1.DeletePoliciesRequest
	2,  // 20: buf.registry.policy.v1beta1.PolicyService.GetPolicies:output_type -> buf.registry.policy.v1beta1.GetPoliciesResponse
	4,  // 21: buf.registry.policy.v1beta1.PolicyService.ListPolicies:output_type -> buf.registry.policy.v1beta1.ListPoliciesResponse
	6,  // 22: buf.registry.policy.v1beta1.PolicyService.CreatePolicies:output_type -> buf.registry.policy.v1beta1.CreatePoliciesResponse
	8,  // 23: buf.registry.policy.v1beta1.PolicyService.UpdatePolicies:output_type -> buf.registry.policy.v1beta1.UpdatePoliciesResponse
	10, // 24: buf.registry.policy.v1beta1.PolicyService.DeletePolicies:output_type -> buf.registry.policy.v1beta1.DeletePoliciesResponse
	20, // [20:25] is the sub-list for method output_type
	15, // [15:20] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_buf_registry_policy_v1beta1_policy_service_proto_init() }
func file_buf_registry_policy_v1beta1_policy_service_proto_init() {
	if File_buf_registry_policy_v1beta1_policy_service_proto != nil {
		return
	}
	file_buf_registry_policy_v1beta1_policy_proto_init()
	file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes[11].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_policy_v1beta1_policy_service_proto_rawDesc), len(file_buf_registry_policy_v1beta1_policy_service_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_policy_v1beta1_policy_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_policy_v1beta1_policy_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_policy_v1beta1_policy_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_policy_v1beta1_policy_service_proto_msgTypes,
	}.Build()
	File_buf_registry_policy_v1beta1_policy_service_proto = out.File
	file_buf_registry_policy_v1beta1_policy_service_proto_goTypes = nil
	file_buf_registry_policy_v1beta1_policy_service_proto_depIdxs = nil
}
