// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/registry/module/v1beta1/download_service.proto

//go:build protoopaque

package modulev1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DownloadRequest struct {
	state                 protoimpl.MessageState    `protogen:"opaque.v1"`
	xxx_hidden_Values     *[]*DownloadRequest_Value `protobuf:"bytes,1,rep,name=values,proto3"`
	xxx_hidden_DigestType DigestType                `protobuf:"varint,2,opt,name=digest_type,json=digestType,proto3,enum=buf.registry.module.v1beta1.DigestType"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *DownloadRequest) Reset() {
	*x = DownloadRequest{}
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadRequest) ProtoMessage() {}

func (x *DownloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DownloadRequest) GetValues() []*DownloadRequest_Value {
	if x != nil {
		if x.xxx_hidden_Values != nil {
			return *x.xxx_hidden_Values
		}
	}
	return nil
}

func (x *DownloadRequest) GetDigestType() DigestType {
	if x != nil {
		return x.xxx_hidden_DigestType
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

func (x *DownloadRequest) SetValues(v []*DownloadRequest_Value) {
	x.xxx_hidden_Values = &v
}

func (x *DownloadRequest) SetDigestType(v DigestType) {
	x.xxx_hidden_DigestType = v
}

type DownloadRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The references to get contents for.
	Values []*DownloadRequest_Value
	// The DigestType to return for the Commits of the references.
	//
	// If this DigestType is not available, an error is returned.
	// Note that certain DigestTypes may be deprecated over time.
	//
	// If not set, the latest DigestType is used, currently B5.
	DigestType DigestType
}

func (b0 DownloadRequest_builder) Build() *DownloadRequest {
	m0 := &DownloadRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Values = &b.Values
	x.xxx_hidden_DigestType = b.DigestType
	return m0
}

type DownloadResponse struct {
	state               protoimpl.MessageState       `protogen:"opaque.v1"`
	xxx_hidden_Contents *[]*DownloadResponse_Content `protobuf:"bytes,1,rep,name=contents,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *DownloadResponse) Reset() {
	*x = DownloadResponse{}
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownloadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadResponse) ProtoMessage() {}

func (x *DownloadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DownloadResponse) GetContents() []*DownloadResponse_Content {
	if x != nil {
		if x.xxx_hidden_Contents != nil {
			return *x.xxx_hidden_Contents
		}
	}
	return nil
}

func (x *DownloadResponse) SetContents(v []*DownloadResponse_Content) {
	x.xxx_hidden_Contents = &v
}

type DownloadResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Contents of the references in the same order as requested.
	Contents []*DownloadResponse_Content
}

func (b0 DownloadResponse_builder) Build() *DownloadResponse {
	m0 := &DownloadResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Contents = &b.Contents
	return m0
}

// A request for content for a single reference.
type DownloadRequest_Value struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ResourceRef        *ResourceRef           `protobuf:"bytes,1,opt,name=resource_ref,json=resourceRef,proto3"`
	xxx_hidden_FileTypes          []FileType             `protobuf:"varint,2,rep,packed,name=file_types,json=fileTypes,proto3,enum=buf.registry.module.v1beta1.FileType"`
	xxx_hidden_Paths              []string               `protobuf:"bytes,3,rep,name=paths,proto3"`
	xxx_hidden_PathsAllowNotExist bool                   `protobuf:"varint,4,opt,name=paths_allow_not_exist,json=pathsAllowNotExist,proto3"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *DownloadRequest_Value) Reset() {
	*x = DownloadRequest_Value{}
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownloadRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadRequest_Value) ProtoMessage() {}

func (x *DownloadRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DownloadRequest_Value) GetResourceRef() *ResourceRef {
	if x != nil {
		return x.xxx_hidden_ResourceRef
	}
	return nil
}

func (x *DownloadRequest_Value) GetFileTypes() []FileType {
	if x != nil {
		return x.xxx_hidden_FileTypes
	}
	return nil
}

func (x *DownloadRequest_Value) GetPaths() []string {
	if x != nil {
		return x.xxx_hidden_Paths
	}
	return nil
}

func (x *DownloadRequest_Value) GetPathsAllowNotExist() bool {
	if x != nil {
		return x.xxx_hidden_PathsAllowNotExist
	}
	return false
}

func (x *DownloadRequest_Value) SetResourceRef(v *ResourceRef) {
	x.xxx_hidden_ResourceRef = v
}

func (x *DownloadRequest_Value) SetFileTypes(v []FileType) {
	x.xxx_hidden_FileTypes = v
}

func (x *DownloadRequest_Value) SetPaths(v []string) {
	x.xxx_hidden_Paths = v
}

func (x *DownloadRequest_Value) SetPathsAllowNotExist(v bool) {
	x.xxx_hidden_PathsAllowNotExist = v
}

func (x *DownloadRequest_Value) HasResourceRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ResourceRef != nil
}

func (x *DownloadRequest_Value) ClearResourceRef() {
	x.xxx_hidden_ResourceRef = nil
}

type DownloadRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The reference to get content for.
	//
	// See the documentation on ResourceRef for resource resolution details.
	//
	// Once the resource is resolved, the following content is returned:
	//   - If a Module is referenced, the content of the Commit of the default Label is returned.
	//   - If a Label is referenced, the content of the Commit of this Label is returned.
	//   - If a Commit is referenced, the content for this Commit is returned.
	ResourceRef *ResourceRef
	// Specific file types to request.
	//
	// If not set, all file types are returned.
	FileTypes []FileType
	// Specific file paths to retrieve.
	//
	// May be directories. For example, path "foo/bar" will result in files "foo/bar/baz.proto",
	// "foo/bar/LICENSE" being downloaded.
	//
	// If empty, all file paths for the given reference are retrieved.
	//
	// If no paths match, an empty Files list will be returned, however the call may still
	// be successful if paths_allow_not_exist is set (the dependency list may still be on
	// the response). If a directory "foo/bar" is specified but this directory has no files,
	// this is considered to be a non-match.
	//
	// This field also interacts with file_types - if file_types is set, a path only matches
	// if it is also of the file type, and if there are no matching paths for the given FileTypes,
	// an error is returned unless paths_not_allow_exist is set.
	//
	// The path must be relative, and cannot contain any "." or ".." components
	// The separator "/" must be used.
	Paths []string
	// Whether to allow file paths not to exist within the given module.
	//
	// For example, one may want to retrieve the file paths "buf.md" and "README.md",
	// but only expect one to actually exist.
	//
	// If false, it is an error to specify non-existent file paths.
	PathsAllowNotExist bool
}

func (b0 DownloadRequest_Value_builder) Build() *DownloadRequest_Value {
	m0 := &DownloadRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ResourceRef = b.ResourceRef
	x.xxx_hidden_FileTypes = b.FileTypes
	x.xxx_hidden_Paths = b.Paths
	x.xxx_hidden_PathsAllowNotExist = b.PathsAllowNotExist
	return m0
}

// Content for a single Commit.
type DownloadResponse_Content struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Commit        *Commit                `protobuf:"bytes,1,opt,name=commit,proto3"`
	xxx_hidden_Files         *[]*File               `protobuf:"bytes,2,rep,name=files,proto3"`
	xxx_hidden_V1BufYamlFile *File                  `protobuf:"bytes,3,opt,name=v1_buf_yaml_file,json=v1BufYamlFile,proto3"`
	xxx_hidden_V1BufLockFile *File                  `protobuf:"bytes,4,opt,name=v1_buf_lock_file,json=v1BufLockFile,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *DownloadResponse_Content) Reset() {
	*x = DownloadResponse_Content{}
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownloadResponse_Content) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadResponse_Content) ProtoMessage() {}

func (x *DownloadResponse_Content) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_download_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DownloadResponse_Content) GetCommit() *Commit {
	if x != nil {
		return x.xxx_hidden_Commit
	}
	return nil
}

func (x *DownloadResponse_Content) GetFiles() []*File {
	if x != nil {
		if x.xxx_hidden_Files != nil {
			return *x.xxx_hidden_Files
		}
	}
	return nil
}

func (x *DownloadResponse_Content) GetV1BufYamlFile() *File {
	if x != nil {
		return x.xxx_hidden_V1BufYamlFile
	}
	return nil
}

func (x *DownloadResponse_Content) GetV1BufLockFile() *File {
	if x != nil {
		return x.xxx_hidden_V1BufLockFile
	}
	return nil
}

func (x *DownloadResponse_Content) SetCommit(v *Commit) {
	x.xxx_hidden_Commit = v
}

func (x *DownloadResponse_Content) SetFiles(v []*File) {
	x.xxx_hidden_Files = &v
}

func (x *DownloadResponse_Content) SetV1BufYamlFile(v *File) {
	x.xxx_hidden_V1BufYamlFile = v
}

func (x *DownloadResponse_Content) SetV1BufLockFile(v *File) {
	x.xxx_hidden_V1BufLockFile = v
}

func (x *DownloadResponse_Content) HasCommit() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Commit != nil
}

func (x *DownloadResponse_Content) HasV1BufYamlFile() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_V1BufYamlFile != nil
}

func (x *DownloadResponse_Content) HasV1BufLockFile() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_V1BufLockFile != nil
}

func (x *DownloadResponse_Content) ClearCommit() {
	x.xxx_hidden_Commit = nil
}

func (x *DownloadResponse_Content) ClearV1BufYamlFile() {
	x.xxx_hidden_V1BufYamlFile = nil
}

func (x *DownloadResponse_Content) ClearV1BufLockFile() {
	x.xxx_hidden_V1BufLockFile = nil
}

type DownloadResponse_Content_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Commit associated with the Content.
	//
	// The Commit associated with this ID will be present in the commits field.
	//
	// The Commit will use the DigestType specified in the request value.
	Commit *Commit
	// The Files of the content.
	//
	// This will consist of the .proto files, license files, and documentation files.
	//
	// If no paths match and paths_allow_not_exist is set, this may be empty.
	Files []*File
	// The original v1beta1 or v1 buf.yaml file that encapsulated this reference.
	//
	// If the reference was encapsulated by a v2 buf.yaml, this will be a synthesized v1 buf.yaml.
	//
	// This is used in deprecated digest calculations only. None of the structured
	// information within this File conveys further information about the reference.
	V1BufYamlFile *File
	// The original buf.lock file that encapsulated this reference, if it existed.
	//
	// If the reference was encapsulated by a v2 buf.lock with dependencies, this will be a
	// synthesized v1 buf.lock.
	//
	// This is used in deprecated digest calculations only. None of the structured
	// information within this File conveys further information about the reference.
	//
	// Importantly, this file should *not* used to determine the dependencies of the
	// reference. To determine the dependencies, use the GraphService with the returned
	// Commit.
	V1BufLockFile *File
}

func (b0 DownloadResponse_Content_builder) Build() *DownloadResponse_Content {
	m0 := &DownloadResponse_Content{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Commit = b.Commit
	x.xxx_hidden_Files = &b.Files
	x.xxx_hidden_V1BufYamlFile = b.V1BufYamlFile
	x.xxx_hidden_V1BufLockFile = b.V1BufLockFile
	return m0
}

var File_buf_registry_module_v1beta1_download_service_proto protoreflect.FileDescriptor

const file_buf_registry_module_v1beta1_download_service_proto_rawDesc = "" +
	"\n" +
	"2buf/registry/module/v1beta1/download_service.proto\x12\x1bbuf.registry.module.v1beta1\x1a(buf/registry/module/v1beta1/commit.proto\x1a(buf/registry/module/v1beta1/digest.proto\x1a&buf/registry/module/v1beta1/file.proto\x1a*buf/registry/module/v1beta1/resource.proto\x1a\x1bbuf/validate/validate.proto\"\x98\x04\n" +
	"\x0fDownloadRequest\x12W\n" +
	"\x06values\x18\x01 \x03(\v22.buf.registry.module.v1beta1.DownloadRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x12R\n" +
	"\vdigest_type\x18\x02 \x01(\x0e2'.buf.registry.module.v1beta1.DigestTypeB\b\xbaH\x05\x82\x01\x02\x10\x01R\n" +
	"digestType\x1a\xd7\x02\n" +
	"\x05Value\x12S\n" +
	"\fresource_ref\x18\x01 \x01(\v2(.buf.registry.module.v1beta1.ResourceRefB\x06\xbaH\x03\xc8\x01\x01R\vresourceRef\x12W\n" +
	"\n" +
	"file_types\x18\x02 \x03(\x0e2%.buf.registry.module.v1beta1.FileTypeB\x11\xbaH\x0e\x92\x01\v\x18\x01\"\a\x82\x01\x04\x10\x01 \x00R\tfileTypes\x12m\n" +
	"\x05paths\x18\x03 \x03(\tBW\xbaHT\x92\x01Q\"OrM\x18\x80 2D^([^/.][^/]?|[^/][^/.]|[^/]{3,})(/([^/.][^/]?|[^/][^/.]|[^/]{3,}))*$\xba\x01\x01\\R\x05paths\x121\n" +
	"\x15paths_allow_not_exist\x18\x04 \x01(\bR\x12pathsAllowNotExist\"\x91\x03\n" +
	"\x10DownloadResponse\x12[\n" +
	"\bcontents\x18\x01 \x03(\v25.buf.registry.module.v1beta1.DownloadResponse.ContentB\b\xbaH\x05\x92\x01\x02\b\x01R\bcontents\x1a\x9f\x02\n" +
	"\aContent\x12C\n" +
	"\x06commit\x18\x01 \x01(\v2#.buf.registry.module.v1beta1.CommitB\x06\xbaH\x03\xc8\x01\x01R\x06commit\x127\n" +
	"\x05files\x18\x02 \x03(\v2!.buf.registry.module.v1beta1.FileR\x05files\x12J\n" +
	"\x10v1_buf_yaml_file\x18\x03 \x01(\v2!.buf.registry.module.v1beta1.FileR\rv1BufYamlFile\x12J\n" +
	"\x10v1_buf_lock_file\x18\x04 \x01(\v2!.buf.registry.module.v1beta1.FileR\rv1BufLockFile2\x7f\n" +
	"\x0fDownloadService\x12l\n" +
	"\bDownload\x12,.buf.registry.module.v1beta1.DownloadRequest\x1a-.buf.registry.module.v1beta1.DownloadResponse\"\x03\x90\x02\x01BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1beta1;modulev1beta1b\x06proto3"

var file_buf_registry_module_v1beta1_download_service_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_buf_registry_module_v1beta1_download_service_proto_goTypes = []any{
	(*DownloadRequest)(nil),          // 0: buf.registry.module.v1beta1.DownloadRequest
	(*DownloadResponse)(nil),         // 1: buf.registry.module.v1beta1.DownloadResponse
	(*DownloadRequest_Value)(nil),    // 2: buf.registry.module.v1beta1.DownloadRequest.Value
	(*DownloadResponse_Content)(nil), // 3: buf.registry.module.v1beta1.DownloadResponse.Content
	(DigestType)(0),                  // 4: buf.registry.module.v1beta1.DigestType
	(*ResourceRef)(nil),              // 5: buf.registry.module.v1beta1.ResourceRef
	(FileType)(0),                    // 6: buf.registry.module.v1beta1.FileType
	(*Commit)(nil),                   // 7: buf.registry.module.v1beta1.Commit
	(*File)(nil),                     // 8: buf.registry.module.v1beta1.File
}
var file_buf_registry_module_v1beta1_download_service_proto_depIdxs = []int32{
	2,  // 0: buf.registry.module.v1beta1.DownloadRequest.values:type_name -> buf.registry.module.v1beta1.DownloadRequest.Value
	4,  // 1: buf.registry.module.v1beta1.DownloadRequest.digest_type:type_name -> buf.registry.module.v1beta1.DigestType
	3,  // 2: buf.registry.module.v1beta1.DownloadResponse.contents:type_name -> buf.registry.module.v1beta1.DownloadResponse.Content
	5,  // 3: buf.registry.module.v1beta1.DownloadRequest.Value.resource_ref:type_name -> buf.registry.module.v1beta1.ResourceRef
	6,  // 4: buf.registry.module.v1beta1.DownloadRequest.Value.file_types:type_name -> buf.registry.module.v1beta1.FileType
	7,  // 5: buf.registry.module.v1beta1.DownloadResponse.Content.commit:type_name -> buf.registry.module.v1beta1.Commit
	8,  // 6: buf.registry.module.v1beta1.DownloadResponse.Content.files:type_name -> buf.registry.module.v1beta1.File
	8,  // 7: buf.registry.module.v1beta1.DownloadResponse.Content.v1_buf_yaml_file:type_name -> buf.registry.module.v1beta1.File
	8,  // 8: buf.registry.module.v1beta1.DownloadResponse.Content.v1_buf_lock_file:type_name -> buf.registry.module.v1beta1.File
	0,  // 9: buf.registry.module.v1beta1.DownloadService.Download:input_type -> buf.registry.module.v1beta1.DownloadRequest
	1,  // 10: buf.registry.module.v1beta1.DownloadService.Download:output_type -> buf.registry.module.v1beta1.DownloadResponse
	10, // [10:11] is the sub-list for method output_type
	9,  // [9:10] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1beta1_download_service_proto_init() }
func file_buf_registry_module_v1beta1_download_service_proto_init() {
	if File_buf_registry_module_v1beta1_download_service_proto != nil {
		return
	}
	file_buf_registry_module_v1beta1_commit_proto_init()
	file_buf_registry_module_v1beta1_digest_proto_init()
	file_buf_registry_module_v1beta1_file_proto_init()
	file_buf_registry_module_v1beta1_resource_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_module_v1beta1_download_service_proto_rawDesc), len(file_buf_registry_module_v1beta1_download_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1beta1_download_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1beta1_download_service_proto_depIdxs,
		MessageInfos:      file_buf_registry_module_v1beta1_download_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1beta1_download_service_proto = out.File
	file_buf_registry_module_v1beta1_download_service_proto_goTypes = nil
	file_buf_registry_module_v1beta1_download_service_proto_depIdxs = nil
}
