// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/registry/owner/v1/user_service.proto

package ownerv1connect

import (
	v1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// UserServiceName is the fully-qualified name of the UserService service.
	UserServiceName = "buf.registry.owner.v1.UserService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// UserServiceGetUsersProcedure is the fully-qualified name of the UserService's GetUsers RPC.
	UserServiceGetUsersProcedure = "/buf.registry.owner.v1.UserService/GetUsers"
	// UserServiceListUsersProcedure is the fully-qualified name of the UserService's ListUsers RPC.
	UserServiceListUsersProcedure = "/buf.registry.owner.v1.UserService/ListUsers"
	// UserServiceCreateUsersProcedure is the fully-qualified name of the UserService's CreateUsers RPC.
	UserServiceCreateUsersProcedure = "/buf.registry.owner.v1.UserService/CreateUsers"
	// UserServiceUpdateUsersProcedure is the fully-qualified name of the UserService's UpdateUsers RPC.
	UserServiceUpdateUsersProcedure = "/buf.registry.owner.v1.UserService/UpdateUsers"
	// UserServiceDeleteUsersProcedure is the fully-qualified name of the UserService's DeleteUsers RPC.
	UserServiceDeleteUsersProcedure = "/buf.registry.owner.v1.UserService/DeleteUsers"
)

// UserServiceClient is a client for the buf.registry.owner.v1.UserService service.
type UserServiceClient interface {
	// Get Users by id or name.
	GetUsers(context.Context, *connect.Request[v1.GetUsersRequest]) (*connect.Response[v1.GetUsersResponse], error)
	// List Users, usually by Organization.
	ListUsers(context.Context, *connect.Request[v1.ListUsersRequest]) (*connect.Response[v1.ListUsersResponse], error)
	// Create new Users.
	//
	// This operation is atomic. Either all Users are created or an error is returned.
	CreateUsers(context.Context, *connect.Request[v1.CreateUsersRequest]) (*connect.Response[v1.CreateUsersResponse], error)
	// Update existing Users.
	//
	// This operation is atomic. Either all Users are updated or an error is returned.
	UpdateUsers(context.Context, *connect.Request[v1.UpdateUsersRequest]) (*connect.Response[v1.UpdateUsersResponse], error)
	// Delete existing Users.
	//
	// This operation is atomic. Either all Users are deleted or an error is returned.
	// Duplicate UserRefs are allowed, and only one User will be deleted. Likewise,
	// duplicate UserRefs belonging to the same User, by id or name, are allowed, and
	// only one User will be deleted.
	DeleteUsers(context.Context, *connect.Request[v1.DeleteUsersRequest]) (*connect.Response[v1.DeleteUsersResponse], error)
}

// NewUserServiceClient constructs a client for the buf.registry.owner.v1.UserService service. By
// default, it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses,
// and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the
// connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewUserServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) UserServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	userServiceMethods := v1.File_buf_registry_owner_v1_user_service_proto.Services().ByName("UserService").Methods()
	return &userServiceClient{
		getUsers: connect.NewClient[v1.GetUsersRequest, v1.GetUsersResponse](
			httpClient,
			baseURL+UserServiceGetUsersProcedure,
			connect.WithSchema(userServiceMethods.ByName("GetUsers")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listUsers: connect.NewClient[v1.ListUsersRequest, v1.ListUsersResponse](
			httpClient,
			baseURL+UserServiceListUsersProcedure,
			connect.WithSchema(userServiceMethods.ByName("ListUsers")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		createUsers: connect.NewClient[v1.CreateUsersRequest, v1.CreateUsersResponse](
			httpClient,
			baseURL+UserServiceCreateUsersProcedure,
			connect.WithSchema(userServiceMethods.ByName("CreateUsers")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		updateUsers: connect.NewClient[v1.UpdateUsersRequest, v1.UpdateUsersResponse](
			httpClient,
			baseURL+UserServiceUpdateUsersProcedure,
			connect.WithSchema(userServiceMethods.ByName("UpdateUsers")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		deleteUsers: connect.NewClient[v1.DeleteUsersRequest, v1.DeleteUsersResponse](
			httpClient,
			baseURL+UserServiceDeleteUsersProcedure,
			connect.WithSchema(userServiceMethods.ByName("DeleteUsers")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
	}
}

// userServiceClient implements UserServiceClient.
type userServiceClient struct {
	getUsers    *connect.Client[v1.GetUsersRequest, v1.GetUsersResponse]
	listUsers   *connect.Client[v1.ListUsersRequest, v1.ListUsersResponse]
	createUsers *connect.Client[v1.CreateUsersRequest, v1.CreateUsersResponse]
	updateUsers *connect.Client[v1.UpdateUsersRequest, v1.UpdateUsersResponse]
	deleteUsers *connect.Client[v1.DeleteUsersRequest, v1.DeleteUsersResponse]
}

// GetUsers calls buf.registry.owner.v1.UserService.GetUsers.
func (c *userServiceClient) GetUsers(ctx context.Context, req *connect.Request[v1.GetUsersRequest]) (*connect.Response[v1.GetUsersResponse], error) {
	return c.getUsers.CallUnary(ctx, req)
}

// ListUsers calls buf.registry.owner.v1.UserService.ListUsers.
func (c *userServiceClient) ListUsers(ctx context.Context, req *connect.Request[v1.ListUsersRequest]) (*connect.Response[v1.ListUsersResponse], error) {
	return c.listUsers.CallUnary(ctx, req)
}

// CreateUsers calls buf.registry.owner.v1.UserService.CreateUsers.
func (c *userServiceClient) CreateUsers(ctx context.Context, req *connect.Request[v1.CreateUsersRequest]) (*connect.Response[v1.CreateUsersResponse], error) {
	return c.createUsers.CallUnary(ctx, req)
}

// UpdateUsers calls buf.registry.owner.v1.UserService.UpdateUsers.
func (c *userServiceClient) UpdateUsers(ctx context.Context, req *connect.Request[v1.UpdateUsersRequest]) (*connect.Response[v1.UpdateUsersResponse], error) {
	return c.updateUsers.CallUnary(ctx, req)
}

// DeleteUsers calls buf.registry.owner.v1.UserService.DeleteUsers.
func (c *userServiceClient) DeleteUsers(ctx context.Context, req *connect.Request[v1.DeleteUsersRequest]) (*connect.Response[v1.DeleteUsersResponse], error) {
	return c.deleteUsers.CallUnary(ctx, req)
}

// UserServiceHandler is an implementation of the buf.registry.owner.v1.UserService service.
type UserServiceHandler interface {
	// Get Users by id or name.
	GetUsers(context.Context, *connect.Request[v1.GetUsersRequest]) (*connect.Response[v1.GetUsersResponse], error)
	// List Users, usually by Organization.
	ListUsers(context.Context, *connect.Request[v1.ListUsersRequest]) (*connect.Response[v1.ListUsersResponse], error)
	// Create new Users.
	//
	// This operation is atomic. Either all Users are created or an error is returned.
	CreateUsers(context.Context, *connect.Request[v1.CreateUsersRequest]) (*connect.Response[v1.CreateUsersResponse], error)
	// Update existing Users.
	//
	// This operation is atomic. Either all Users are updated or an error is returned.
	UpdateUsers(context.Context, *connect.Request[v1.UpdateUsersRequest]) (*connect.Response[v1.UpdateUsersResponse], error)
	// Delete existing Users.
	//
	// This operation is atomic. Either all Users are deleted or an error is returned.
	// Duplicate UserRefs are allowed, and only one User will be deleted. Likewise,
	// duplicate UserRefs belonging to the same User, by id or name, are allowed, and
	// only one User will be deleted.
	DeleteUsers(context.Context, *connect.Request[v1.DeleteUsersRequest]) (*connect.Response[v1.DeleteUsersResponse], error)
}

// NewUserServiceHandler builds an HTTP handler from the service implementation. It returns the path
// on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewUserServiceHandler(svc UserServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	userServiceMethods := v1.File_buf_registry_owner_v1_user_service_proto.Services().ByName("UserService").Methods()
	userServiceGetUsersHandler := connect.NewUnaryHandler(
		UserServiceGetUsersProcedure,
		svc.GetUsers,
		connect.WithSchema(userServiceMethods.ByName("GetUsers")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	userServiceListUsersHandler := connect.NewUnaryHandler(
		UserServiceListUsersProcedure,
		svc.ListUsers,
		connect.WithSchema(userServiceMethods.ByName("ListUsers")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	userServiceCreateUsersHandler := connect.NewUnaryHandler(
		UserServiceCreateUsersProcedure,
		svc.CreateUsers,
		connect.WithSchema(userServiceMethods.ByName("CreateUsers")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	userServiceUpdateUsersHandler := connect.NewUnaryHandler(
		UserServiceUpdateUsersProcedure,
		svc.UpdateUsers,
		connect.WithSchema(userServiceMethods.ByName("UpdateUsers")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	userServiceDeleteUsersHandler := connect.NewUnaryHandler(
		UserServiceDeleteUsersProcedure,
		svc.DeleteUsers,
		connect.WithSchema(userServiceMethods.ByName("DeleteUsers")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.registry.owner.v1.UserService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case UserServiceGetUsersProcedure:
			userServiceGetUsersHandler.ServeHTTP(w, r)
		case UserServiceListUsersProcedure:
			userServiceListUsersHandler.ServeHTTP(w, r)
		case UserServiceCreateUsersProcedure:
			userServiceCreateUsersHandler.ServeHTTP(w, r)
		case UserServiceUpdateUsersProcedure:
			userServiceUpdateUsersHandler.ServeHTTP(w, r)
		case UserServiceDeleteUsersProcedure:
			userServiceDeleteUsersHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedUserServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedUserServiceHandler struct{}

func (UnimplementedUserServiceHandler) GetUsers(context.Context, *connect.Request[v1.GetUsersRequest]) (*connect.Response[v1.GetUsersResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.UserService.GetUsers is not implemented"))
}

func (UnimplementedUserServiceHandler) ListUsers(context.Context, *connect.Request[v1.ListUsersRequest]) (*connect.Response[v1.ListUsersResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.UserService.ListUsers is not implemented"))
}

func (UnimplementedUserServiceHandler) CreateUsers(context.Context, *connect.Request[v1.CreateUsersRequest]) (*connect.Response[v1.CreateUsersResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.UserService.CreateUsers is not implemented"))
}

func (UnimplementedUserServiceHandler) UpdateUsers(context.Context, *connect.Request[v1.UpdateUsersRequest]) (*connect.Response[v1.UpdateUsersResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.UserService.UpdateUsers is not implemented"))
}

func (UnimplementedUserServiceHandler) DeleteUsers(context.Context, *connect.Request[v1.DeleteUsersRequest]) (*connect.Response[v1.DeleteUsersResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.UserService.DeleteUsers is not implemented"))
}
